rule win_voidoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.voidoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.voidoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8d4db8 e9???????? 8d8d70ffffff e9???????? 8d8d40ffffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e9????????           |                     
            //   8d8d70ffffff         | lea                 ecx, [ebp - 0x90]
            //   e9????????           |                     
            //   8d8d40ffffff         | lea                 ecx, [ebp - 0xc0]
            //   e9????????           |                     

        $sequence_1 = { ffb6d80b0000 ffb6a0090000 68???????? e8???????? 83c40c 85c0 74a5 }
            // n = 7, score = 100
            //   ffb6d80b0000         | push                dword ptr [esi + 0xbd8]
            //   ffb6a0090000         | push                dword ptr [esi + 0x9a0]
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   74a5                 | je                  0xffffffa7

        $sequence_2 = { 5b 8b4c241c 33cc e8???????? 83c420 c3 8b7e04 }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   c3                   | ret                 
            //   8b7e04               | mov                 edi, dword ptr [esi + 4]

        $sequence_3 = { c744242801000000 8dbbbc000000 6a40 8d442424 50 6a02 ff742420 }
            // n = 7, score = 100
            //   c744242801000000     | mov                 dword ptr [esp + 0x28], 1
            //   8dbbbc000000         | lea                 edi, [ebx + 0xbc]
            //   6a40                 | push                0x40
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   6a02                 | push                2
            //   ff742420             | push                dword ptr [esp + 0x20]

        $sequence_4 = { ff30 ff15???????? 8b4308 83c41c c70000000000 33c0 81fd00030980 }
            // n = 7, score = 100
            //   ff30                 | push                dword ptr [eax]
            //   ff15????????         |                     
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   83c41c               | add                 esp, 0x1c
            //   c70000000000         | mov                 dword ptr [eax], 0
            //   33c0                 | xor                 eax, eax
            //   81fd00030980         | cmp                 ebp, 0x80090300

        $sequence_5 = { b90b000000 f3a5 8d836c010000 50 8d833c010000 50 ff742418 }
            // n = 7, score = 100
            //   b90b000000           | mov                 ecx, 0xb
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8d836c010000         | lea                 eax, [ebx + 0x16c]
            //   50                   | push                eax
            //   8d833c010000         | lea                 eax, [ebx + 0x13c]
            //   50                   | push                eax
            //   ff742418             | push                dword ptr [esp + 0x18]

        $sequence_6 = { ff5018 eb07 8bce e8???????? 8b4de8 8bd8 895de4 }
            // n = 7, score = 100
            //   ff5018               | call                dword ptr [eax + 0x18]
            //   eb07                 | jmp                 9
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   8bd8                 | mov                 ebx, eax
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx

        $sequence_7 = { c70016000000 e8???????? 83c8ff 0bd0 eb35 e8???????? 85c0 }
            // n = 7, score = 100
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   e8????????           |                     
            //   83c8ff               | or                  eax, 0xffffffff
            //   0bd0                 | or                  edx, eax
            //   eb35                 | jmp                 0x37
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { e8???????? 8bf0 83c404 85f6 7508 8d7001 e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   7508                 | jne                 0xa
            //   8d7001               | lea                 esi, [eax + 1]
            //   e9????????           |                     

        $sequence_9 = { e8???????? 6a00 32d2 8d4db4 c645fc08 e8???????? 83c434 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a00                 | push                0
            //   32d2                 | xor                 dl, dl
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   c645fc08             | mov                 byte ptr [ebp - 4], 8
            //   e8????????           |                     
            //   83c434               | add                 esp, 0x34

    condition:
        7 of them and filesize < 1744896
}