rule win_voldemort_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.voldemort."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.voldemort"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bd9 4d896bd0 488d0de3ea0200 4d8be8 4d8973c8 0f57c0 4d897bc0 }
            // n = 7, score = 100
            //   488bd9               | inc                 ebp
            //   4d896bd0             | xor                 ecx, ecx
            //   488d0de3ea0200       | dec                 eax
            //   4d8be8               | lea                 edx, [ebx + 1]
            //   4d8973c8             | inc                 ebp
            //   0f57c0               | xor                 eax, eax
            //   4d897bc0             | inc                 sp

        $sequence_1 = { e8???????? 488bd8 4885c0 7517 488d0daf740300 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488bd8               | mov                 ebx, eax
            //   4885c0               | dec                 eax
            //   7517                 | lea                 ecx, [0x33da0]
            //   488d0daf740300       | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { 4885c0 7517 488d0de43b0300 e8???????? 488bc8 e8???????? 488bd8 }
            // n = 7, score = 100
            //   4885c0               | dec                 eax
            //   7517                 | sar                 eax, 6
            //   488d0de43b0300       | dec                 eax
            //   e8????????           |                     
            //   488bc8               | lea                 ecx, [0x136d4]
            //   e8????????           |                     
            //   488bd8               | inc                 ecx

        $sequence_3 = { 80fa80 73e9 4c8bc3 4d2bc1 4c3bcb 4d0f47c5 4d85c0 }
            // n = 7, score = 100
            //   80fa80               | mov                 edi, ebx
            //   73e9                 | mov                 esi, eax
            //   4c8bc3               | nop                 
            //   4d2bc1               | add                 eax, edx
            //   4c3bcb               | sar                 eax, 3
            //   4d0f47c5             | test                eax, eax
            //   4d85c0               | jle                 0x1ce

        $sequence_4 = { 488b7c2450 488d0d0e7b0300 e8???????? 488bc8 e8???????? 4c8bac2490000000 488bd8 }
            // n = 7, score = 100
            //   488b7c2450           | dec                 eax
            //   488d0d0e7b0300       | mov                 dword ptr [esp + 0x20], edx
            //   e8????????           |                     
            //   488bc8               | inc                 ecx
            //   e8????????           |                     
            //   4c8bac2490000000     | mov                 eax, 0x40000001
            //   488bd8               | inc                 ecx

        $sequence_5 = { 488b8540090000 41b808020000 48894c2468 488d8da0000000 4889442458 4c894c2448 e8???????? }
            // n = 7, score = 100
            //   488b8540090000       | dec                 eax
            //   41b808020000         | lea                 edx, [esp + 0x70]
            //   48894c2468           | dec                 eax
            //   488d8da0000000       | lea                 ecx, [esp + 0x180]
            //   4889442458           | dec                 esp
            //   4c894c2448           | mov                 ecx, ebp
            //   e8????????           |                     

        $sequence_6 = { 48894108 488b4710 48894808 48ffc6 493bf7 7caf 4885ff }
            // n = 7, score = 100
            //   48894108             | mov                 dword ptr [esp + 0x20], eax
            //   488b4710             | dec                 ecx
            //   48894808             | mov                 edx, esi
            //   48ffc6               | dec                 eax
            //   493bf7               | mov                 ecx, eax
            //   7caf                 | dec                 esp
            //   4885ff               | lea                 ecx, [0x2bbef]

        $sequence_7 = { d3e0 83c107 0bf8 80fa80 73e9 4c8bc3 4d2bc1 }
            // n = 7, score = 100
            //   d3e0                 | test                eax, eax
            //   83c107               | xor                 edx, edx
            //   0bf8                 | dec                 eax
            //   80fa80               | mov                 dword ptr [esp + 0x28], eax
            //   73e9                 | inc                 ecx
            //   4c8bc3               | mov                 eax, 0x208
            //   4d2bc1               | dec                 eax

        $sequence_8 = { 488bd5 488bce e8???????? 4963de 4803c3 483bc5 7626 }
            // n = 7, score = 100
            //   488bd5               | dec                 eax
            //   488bce               | sub                 esp, 0x660
            //   e8????????           |                     
            //   4963de               | push                esi
            //   4803c3               | push                edi
            //   483bc5               | inc                 ecx
            //   7626                 | push                esi

        $sequence_9 = { 488bc8 e8???????? 488bd8 4885c0 7517 488d0dde400300 e8???????? }
            // n = 7, score = 100
            //   488bc8               | dec                 esp
            //   e8????????           |                     
            //   488bd8               | mov                 edi, eax
            //   4885c0               | dec                 esp
            //   7517                 | lea                 eax, [ebp + 0x70]
            //   488d0dde400300       | dec                 eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 561152
}