rule win_w32times_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.w32times."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.w32times"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d 5b 81c4ec0c0000 c3 85ed }
            // n = 5, score = 200
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   81c4ec0c0000         | add                 esp, 0xcec
            //   c3                   | ret                 
            //   85ed                 | test                ebp, ebp

        $sequence_1 = { 6a03 55 6a01 8d8c2410080000 6800000080 }
            // n = 5, score = 200
            //   6a03                 | push                3
            //   55                   | push                ebp
            //   6a01                 | push                1
            //   8d8c2410080000       | lea                 ecx, [esp + 0x810]
            //   6800000080           | push                0x80000000

        $sequence_2 = { 33db b900400000 33c0 8d7c2414 f3ab 8d442414 50 }
            // n = 7, score = 200
            //   33db                 | xor                 ebx, ebx
            //   b900400000           | mov                 ecx, 0x4000
            //   33c0                 | xor                 eax, eax
            //   8d7c2414             | lea                 edi, [esp + 0x14]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax

        $sequence_3 = { 85c0 7505 bb02000000 6a28 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   bb02000000           | mov                 ebx, 2
            //   6a28                 | push                0x28

        $sequence_4 = { 53 52 50 ff15???????? 8b4c2434 83c424 51 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   83c424               | add                 esp, 0x24
            //   51                   | push                ecx

        $sequence_5 = { 7518 68???????? ffd6 68???????? c705????????01000000 }
            // n = 5, score = 200
            //   7518                 | jne                 0x1a
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   c705????????01000000     |     

        $sequence_6 = { 8b15???????? 52 ffd3 892d???????? a1???????? 3bc5 7416 }
            // n = 7, score = 200
            //   8b15????????         |                     
            //   52                   | push                edx
            //   ffd3                 | call                ebx
            //   892d????????         |                     
            //   a1????????           |                     
            //   3bc5                 | cmp                 eax, ebp
            //   7416                 | je                  0x18

        $sequence_7 = { c3 50 68???????? ff15???????? 83c408 32c0 5f }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8
            //   32c0                 | xor                 al, al
            //   5f                   | pop                 edi

        $sequence_8 = { 8bf7 c1e902 8bfa 8d9424f4030000 f3a5 8bc8 }
            // n = 6, score = 200
            //   8bf7                 | mov                 esi, edi
            //   c1e902               | shr                 ecx, 2
            //   8bfa                 | mov                 edi, edx
            //   8d9424f4030000       | lea                 edx, [esp + 0x3f4]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax

        $sequence_9 = { 83c40c 85c0 0f85e00c0000 8b4b04 6a04 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f85e00c0000         | jne                 0xce6
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   6a04                 | push                4

    condition:
        7 of them and filesize < 122880
}