rule win_warhawk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.warhawk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.warhawk"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f84d4feffff 5f 8bc6 5e 5b }
            // n = 5, score = 100
            //   0f84d4feffff         | je                  0xfffffeda
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_1 = { 803c0a20 7706 41 894e08 ebf0 3bc8 7504 }
            // n = 7, score = 100
            //   803c0a20             | cmp                 byte ptr [edx + ecx], 0x20
            //   7706                 | ja                  8
            //   41                   | inc                 ecx
            //   894e08               | mov                 dword ptr [esi + 8], ecx
            //   ebf0                 | jmp                 0xfffffff2
            //   3bc8                 | cmp                 ecx, eax
            //   7504                 | jne                 6

        $sequence_2 = { ff7510 e8???????? 8b7d08 8bf0 85ff 0f84b1000000 8b5d0c }
            // n = 7, score = 100
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8bf0                 | mov                 esi, eax
            //   85ff                 | test                edi, edi
            //   0f84b1000000         | je                  0xb7
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_3 = { 0f8490000000 8d45f4 0f57c0 50 0f2945e0 }
            // n = 5, score = 100
            //   0f8490000000         | je                  0x96
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   0f57c0               | xorps               xmm0, xmm0
            //   50                   | push                eax
            //   0f2945e0             | movaps              xmmword ptr [ebp - 0x20], xmm0

        $sequence_4 = { 50 8d44247c 50 8d842474030000 68???????? 50 ffd6 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d44247c             | lea                 eax, [esp + 0x7c]
            //   50                   | push                eax
            //   8d842474030000       | lea                 eax, [esp + 0x374]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_5 = { a3???????? eb33 8b85f8fbffff 8b04b0 0305???????? 50 68???????? }
            // n = 7, score = 100
            //   a3????????           |                     
            //   eb33                 | jmp                 0x35
            //   8b85f8fbffff         | mov                 eax, dword ptr [ebp - 0x408]
            //   8b04b0               | mov                 eax, dword ptr [eax + esi*4]
            //   0305????????         |                     
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_6 = { 8bf0 8b85f0f7ffff ff7010 a1???????? 68???????? 68???????? }
            // n = 6, score = 100
            //   8bf0                 | mov                 esi, eax
            //   8b85f0f7ffff         | mov                 eax, dword ptr [ebp - 0x810]
            //   ff7010               | push                dword ptr [eax + 0x10]
            //   a1????????           |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_7 = { 8974243c ebce 8b44243c 47 8974243c 8930 894604 }
            // n = 7, score = 100
            //   8974243c             | mov                 dword ptr [esp + 0x3c], esi
            //   ebce                 | jmp                 0xffffffd0
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   47                   | inc                 edi
            //   8974243c             | mov                 dword ptr [esp + 0x3c], esi
            //   8930                 | mov                 dword ptr [eax], esi
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_8 = { 7407 8b4e04 8b06 8901 8b0e }
            // n = 5, score = 100
            //   7407                 | je                  9
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b0e                 | mov                 ecx, dword ptr [esi]

        $sequence_9 = { eb49 b9???????? 8bc2 8a18 3a19 885dfb bb00000000 }
            // n = 7, score = 100
            //   eb49                 | jmp                 0x4b
            //   b9????????           |                     
            //   8bc2                 | mov                 eax, edx
            //   8a18                 | mov                 bl, byte ptr [eax]
            //   3a19                 | cmp                 bl, byte ptr [ecx]
            //   885dfb               | mov                 byte ptr [ebp - 5], bl
            //   bb00000000           | mov                 ebx, 0

    condition:
        7 of them and filesize < 2345984
}