rule win_wastedloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.wastedloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wastedloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7444 eb00 686bb90000 ff15???????? }
            // n = 4, score = 100
            //   7444                 | je                  0x46
            //   eb00                 | jmp                 2
            //   686bb90000           | push                0xb96b
            //   ff15????????         |                     

        $sequence_1 = { 7ed7 7488 09b31ced6185 1ce2 }
            // n = 4, score = 100
            //   7ed7                 | jle                 0xffffffd9
            //   7488                 | je                  0xffffff8a
            //   09b31ced6185         | or                  dword ptr [ebx - 0x7a9e12e4], esi
            //   1ce2                 | sbb                 al, 0xe2

        $sequence_2 = { e8???????? 3d1e050000 c10147 833b38 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   3d1e050000           | cmp                 eax, 0x51e
            //   c10147               | rol                 dword ptr [ecx], 0x47
            //   833b38               | cmp                 dword ptr [ebx], 0x38

        $sequence_3 = { a828 b409 1c04 e8???????? }
            // n = 4, score = 100
            //   a828                 | test                al, 0x28
            //   b409                 | mov                 ah, 9
            //   1c04                 | sbb                 al, 4
            //   e8????????           |                     

        $sequence_4 = { 7aec e471 e8???????? 0057bb 038919fc885d e479 }
            // n = 6, score = 100
            //   7aec                 | jp                  0xffffffee
            //   e471                 | in                  al, 0x71
            //   e8????????           |                     
            //   0057bb               | add                 byte ptr [edi - 0x45], dl
            //   038919fc885d         | add                 ecx, dword ptr [ecx + 0x5d88fc19]
            //   e479                 | in                  al, 0x79

        $sequence_5 = { b9b5000000 8b55f8 66894a4c 8b45f8 }
            // n = 4, score = 100
            //   b9b5000000           | mov                 ecx, 0xb5
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   66894a4c             | mov                 word ptr [edx + 0x4c], cx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_6 = { 8b45f8 66895056 b9b8000000 8b55f8 66894a58 8b45f8 0fb74858 }
            // n = 7, score = 100
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   66895056             | mov                 word ptr [eax + 0x56], dx
            //   b9b8000000           | mov                 ecx, 0xb8
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   66894a58             | mov                 word ptr [edx + 0x58], cx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0fb74858             | movzx               ecx, word ptr [eax + 0x58]

        $sequence_7 = { 0200 00e7 aa 53 }
            // n = 4, score = 100
            //   0200                 | add                 al, byte ptr [eax]
            //   00e7                 | add                 bh, ah
            //   aa                   | stosb               byte ptr es:[edi], al
            //   53                   | push                ebx

        $sequence_8 = { 2cbe 832061 5b 5b }
            // n = 4, score = 100
            //   2cbe                 | sub                 al, 0xbe
            //   832061               | and                 dword ptr [eax], 0x61
            //   5b                   | pop                 ebx
            //   5b                   | pop                 ebx

        $sequence_9 = { 8b55f8 0fb7421e 83e854 8b4df8 6689411e ba86000000 }
            // n = 6, score = 100
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   0fb7421e             | movzx               eax, word ptr [edx + 0x1e]
            //   83e854               | sub                 eax, 0x54
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   6689411e             | mov                 word ptr [ecx + 0x1e], ax
            //   ba86000000           | mov                 edx, 0x86

    condition:
        7 of them and filesize < 2677760
}