rule win_webc2_head_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_head."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_head"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e61f 8d3c8d40cb4000 c1e603 8b0f 833c31ff 7536 833d????????01 }
            // n = 7, score = 100
            //   83e61f               | and                 esi, 0x1f
            //   8d3c8d40cb4000       | lea                 edi, [ecx*4 + 0x40cb40]
            //   c1e603               | shl                 esi, 3
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   833c31ff             | cmp                 dword ptr [ecx + esi], -1
            //   7536                 | jne                 0x38
            //   833d????????01       |                     

        $sequence_1 = { e8???????? 83c410 8d4c2418 8d942444080000 03f0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   8d942444080000       | lea                 edx, [esp + 0x844]
            //   03f0                 | add                 esi, eax

        $sequence_2 = { 894c2424 896c241c 7e1a 8b742420 8bd1 8d7c241c }
            // n = 6, score = 100
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx
            //   896c241c             | mov                 dword ptr [esp + 0x1c], ebp
            //   7e1a                 | jle                 0x1c
            //   8b742420             | mov                 esi, dword ptr [esp + 0x20]
            //   8bd1                 | mov                 edx, ecx
            //   8d7c241c             | lea                 edi, [esp + 0x1c]

        $sequence_3 = { 8d8decfaffff 668b11 f6c201 7416 8088????????10 8a9405ecfdffff 8890e0b84000 }
            // n = 7, score = 100
            //   8d8decfaffff         | lea                 ecx, [ebp - 0x514]
            //   668b11               | mov                 dx, word ptr [ecx]
            //   f6c201               | test                dl, 1
            //   7416                 | je                  0x18
            //   8088????????10       |                     
            //   8a9405ecfdffff       | mov                 dl, byte ptr [ebp + eax - 0x214]
            //   8890e0b84000         | mov                 byte ptr [eax + 0x40b8e0], dl

        $sequence_4 = { d04040 00fc 40 40 0020 }
            // n = 5, score = 100
            //   d04040               | rol                 byte ptr [eax + 0x40], 1
            //   00fc                 | add                 ah, bh
            //   40                   | inc                 eax
            //   40                   | inc                 eax
            //   0020                 | add                 byte ptr [eax], ah

        $sequence_5 = { 6800040000 68???????? f3ab 55 c744242c00000000 }
            // n = 5, score = 100
            //   6800040000           | push                0x400
            //   68????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   55                   | push                ebp
            //   c744242c00000000     | mov                 dword ptr [esp + 0x2c], 0

        $sequence_6 = { 89542420 33d2 895c2410 bb???????? 85c0 0f8e20010000 b910000000 }
            // n = 7, score = 100
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   33d2                 | xor                 edx, edx
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   bb????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8e20010000         | jle                 0x126
            //   b910000000           | mov                 ecx, 0x10

        $sequence_7 = { 2bca 33ed 85c9 894c2424 896c241c 7e1a }
            // n = 6, score = 100
            //   2bca                 | sub                 ecx, edx
            //   33ed                 | xor                 ebp, ebp
            //   85c9                 | test                ecx, ecx
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx
            //   896c241c             | mov                 dword ptr [esp + 0x1c], ebp
            //   7e1a                 | jle                 0x1c

        $sequence_8 = { 8b7d0c 8d0594b84000 83780800 7543 }
            // n = 4, score = 100
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8d0594b84000         | lea                 eax, [0x40b894]
            //   83780800             | cmp                 dword ptr [eax + 8], 0
            //   7543                 | jne                 0x45

        $sequence_9 = { 6a1f 55 ff15???????? 8b3d???????? 6a04 81cf00330000 }
            // n = 6, score = 100
            //   6a1f                 | push                0x1f
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   6a04                 | push                4
            //   81cf00330000         | or                  edi, 0x3300

    condition:
        7 of them and filesize < 106496
}