rule win_webc2_kt3_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_kt3."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_kt3"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d0c 034dfc 894d0c 8b55f8 2b55fc }
            // n = 5, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   034dfc               | add                 ecx, dword ptr [ebp - 4]
            //   894d0c               | mov                 dword ptr [ebp + 0xc], ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   2b55fc               | sub                 edx, dword ptr [ebp - 4]

        $sequence_1 = { f2ae f7d1 83c1ff b804010000 2bc1 50 }
            // n = 6, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   83c1ff               | add                 ecx, -1
            //   b804010000           | mov                 eax, 0x104
            //   2bc1                 | sub                 eax, ecx
            //   50                   | push                eax

        $sequence_2 = { 8b45d0 50 e8???????? 83c404 b801000000 5f 5e }
            // n = 7, score = 100
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { c705????????043a4000 c705????????ac3a4000 a3???????? c3 }
            // n = 4, score = 100
            //   c705????????043a4000     |     
            //   c705????????ac3a4000     |     
            //   a3????????           |                     
            //   c3                   | ret                 

        $sequence_4 = { 8b4ddc 8b11 52 ff15???????? 0f8408000000 0f8502000000 }
            // n = 6, score = 100
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   0f8408000000         | je                  0xe
            //   0f8502000000         | jne                 8

        $sequence_5 = { 51 ff15???????? 8b55e8 0fbe02 83f873 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   0fbe02               | movsx               eax, byte ptr [edx]
            //   83f873               | cmp                 eax, 0x73

        $sequence_6 = { e9???????? b911000000 33c0 8dbda8feffff f3ab c785a8feffff44000000 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   b911000000           | mov                 ecx, 0x11
            //   33c0                 | xor                 eax, eax
            //   8dbda8feffff         | lea                 edi, [ebp - 0x158]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   c785a8feffff44000000     | mov    dword ptr [ebp - 0x158], 0x44

        $sequence_7 = { 0f8408000000 0f8502000000 ebe9 8b85b0fdffff }
            // n = 4, score = 100
            //   0f8408000000         | je                  0xe
            //   0f8502000000         | jne                 8
            //   ebe9                 | jmp                 0xffffffeb
            //   8b85b0fdffff         | mov                 eax, dword ptr [ebp - 0x250]

        $sequence_8 = { 83e103 f3a4 eb68 8b4d08 c70100000000 6a3a 8b55e8 }
            // n = 7, score = 100
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   eb68                 | jmp                 0x6a
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c70100000000         | mov                 dword ptr [ecx], 0
            //   6a3a                 | push                0x3a
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]

        $sequence_9 = { 8985f0fbffff 0f8408000000 0f8502000000 ebe9 68???????? }
            // n = 5, score = 100
            //   8985f0fbffff         | mov                 dword ptr [ebp - 0x410], eax
            //   0f8408000000         | je                  0xe
            //   0f8502000000         | jne                 8
            //   ebe9                 | jmp                 0xffffffeb
            //   68????????           |                     

    condition:
        7 of them and filesize < 114688
}