rule win_webc2_table_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_table."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_table"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 85c0 59 7534 8d85e4feffff }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   7534                 | jne                 0x36
            //   8d85e4feffff         | lea                 eax, [ebp - 0x11c]

        $sequence_1 = { 53 50 e8???????? 6a07 8d8558ffffff }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a07                 | push                7
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]

        $sequence_2 = { 56 8d8558ffffff 53 50 e8???????? 6a0a 8d8558ffffff }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a0a                 | push                0xa
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]

        $sequence_3 = { 57 53 894dec ffd6 59 3bc3 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   53                   | push                ebx
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx

        $sequence_4 = { 6880000000 8d8558ffffff 53 50 e8???????? }
            // n = 5, score = 100
            //   6880000000           | push                0x80
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 83c418 ffd6 8d45e4 50 8d45d4 }
            // n = 5, score = 100
            //   83c418               | add                 esp, 0x18
            //   ffd6                 | call                esi
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]

        $sequence_6 = { 8d45e8 c745e864000000 50 8d851cfeffff 50 ff15???????? 8d851cfeffff }
            // n = 7, score = 100
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   c745e864000000       | mov                 dword ptr [ebp - 0x18], 0x64
            //   50                   | push                eax
            //   8d851cfeffff         | lea                 eax, [ebp - 0x1e4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d851cfeffff         | lea                 eax, [ebp - 0x1e4]

        $sequence_7 = { ab ab 66ab aa baff000000 33c0 8bca }
            // n = 7, score = 100
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   baff000000           | mov                 edx, 0xff
            //   33c0                 | xor                 eax, eax
            //   8bca                 | mov                 ecx, edx

        $sequence_8 = { 3bc3 59 0f84fa020000 81fec8000000 0f8dee020000 8d46f5 50 }
            // n = 7, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   59                   | pop                 ecx
            //   0f84fa020000         | je                  0x300
            //   81fec8000000         | cmp                 esi, 0xc8
            //   0f8dee020000         | jge                 0x2f4
            //   8d46f5               | lea                 eax, [esi - 0xb]
            //   50                   | push                eax

        $sequence_9 = { 8b55f0 8bcf 2bd7 8975f8 }
            // n = 4, score = 100
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8bcf                 | mov                 ecx, edi
            //   2bd7                 | sub                 edx, edi
            //   8975f8               | mov                 dword ptr [ebp - 8], esi

    condition:
        7 of them and filesize < 49152
}