rule win_wellmess_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wellmess"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eba1 48 89f0 48 89ce eb8a 48 }
            // n = 7, score = 100
            //   eba1                 | jmp                 0xffffffa3
            //   48                   | dec                 eax
            //   89f0                 | mov                 eax, esi
            //   48                   | dec                 eax
            //   89ce                 | mov                 esi, ecx
            //   eb8a                 | jmp                 0xffffff8c
            //   48                   | dec                 eax

        $sequence_1 = { c744247806000000 48 8b05???????? 48 89442440 48 8d0dfb481a00 }
            // n = 7, score = 100
            //   c744247806000000     | mov                 dword ptr [esp + 0x78], 6
            //   48                   | dec                 eax
            //   8b05????????         |                     
            //   48                   | dec                 eax
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   48                   | dec                 eax
            //   8d0dfb481a00         | lea                 ecx, [0x1a48fb]

        $sequence_2 = { e8???????? 48 8b842490000000 48 8b4c2450 e9???????? 48 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b842490000000       | mov                 eax, dword ptr [esp + 0x90]
            //   48                   | dec                 eax
            //   8b4c2450             | mov                 ecx, dword ptr [esp + 0x50]
            //   e9????????           |                     
            //   48                   | dec                 eax

        $sequence_3 = { c3 48 89842458010000 48 898c2460010000 48 8bac2428010000 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   48                   | dec                 eax
            //   89842458010000       | mov                 dword ptr [esp + 0x158], eax
            //   48                   | dec                 eax
            //   898c2460010000       | mov                 dword ptr [esp + 0x160], ecx
            //   48                   | dec                 eax
            //   8bac2428010000       | mov                 ebp, dword ptr [esp + 0x128]

        $sequence_4 = { c3 48 8d05ce6e2200 48 890424 48 c744240804000000 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   48                   | dec                 eax
            //   8d05ce6e2200         | lea                 eax, [0x226ece]
            //   48                   | dec                 eax
            //   890424               | mov                 dword ptr [esp], eax
            //   48                   | dec                 eax
            //   c744240804000000     | mov                 dword ptr [esp + 8], 4

        $sequence_5 = { c744246400000000 48 c744246800000000 48 c744247000000000 48 c7c214000000 }
            // n = 7, score = 100
            //   c744246400000000     | mov                 dword ptr [esp + 0x64], 0
            //   48                   | dec                 eax
            //   c744246800000000     | mov                 dword ptr [esp + 0x68], 0
            //   48                   | dec                 eax
            //   c744247000000000     | mov                 dword ptr [esp + 0x70], 0
            //   48                   | dec                 eax
            //   c7c214000000         | mov                 edx, 0x14

        $sequence_6 = { 89ce 7460 81fbe263de7a 750e 48 8d0d8a270a00 48 }
            // n = 7, score = 100
            //   89ce                 | mov                 esi, ecx
            //   7460                 | je                  0x62
            //   81fbe263de7a         | cmp                 ebx, 0x7ade63e2
            //   750e                 | jne                 0x10
            //   48                   | dec                 eax
            //   8d0d8a270a00         | lea                 ecx, [0xa278a]
            //   48                   | dec                 eax

        $sequence_7 = { c3 48 891c24 48 89742408 48 8d054d350b00 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   48                   | dec                 eax
            //   891c24               | mov                 dword ptr [esp], ebx
            //   48                   | dec                 eax
            //   89742408             | mov                 dword ptr [esp + 8], esi
            //   48                   | dec                 eax
            //   8d054d350b00         | lea                 eax, [0xb354d]

        $sequence_8 = { f248 0f2cd1 48 8d5a30 885c0c1c 48 ffc1 }
            // n = 7, score = 100
            //   f248                 | dec                 eax
            //   0f2cd1               | cvttps2pi           mm2, xmm1
            //   48                   | dec                 eax
            //   8d5a30               | lea                 ebx, [edx + 0x30]
            //   885c0c1c             | mov                 byte ptr [esp + ecx + 0x1c], bl
            //   48                   | dec                 eax
            //   ffc1                 | inc                 ecx

        $sequence_9 = { c744245014000000 48 8d0549251e00 48 890424 48 8b4c2438 }
            // n = 7, score = 100
            //   c744245014000000     | mov                 dword ptr [esp + 0x50], 0x14
            //   48                   | dec                 eax
            //   8d0549251e00         | lea                 eax, [0x1e2549]
            //   48                   | dec                 eax
            //   890424               | mov                 dword ptr [esp], eax
            //   48                   | dec                 eax
            //   8b4c2438             | mov                 ecx, dword ptr [esp + 0x38]

    condition:
        7 of them and filesize < 12279808
}