rule win_woodyrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.woodyrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.woodyrat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 884604 8bc6 890e 8b4df4 64890d00000000 59 5f }
            // n = 7, score = 100
            //   884604               | mov                 byte ptr [esi + 4], al
            //   8bc6                 | mov                 eax, esi
            //   890e                 | mov                 dword ptr [esi], ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_1 = { c645fc06 8bc4 8d4dc8 51 50 8d4dd4 }
            // n = 6, score = 100
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   8bc4                 | mov                 eax, esp
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]

        $sequence_2 = { 0f8726020000 52 51 e8???????? 83c408 83c654 }
            // n = 6, score = 100
            //   0f8726020000         | ja                  0x22c
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   83c654               | add                 esi, 0x54

        $sequence_3 = { 83ec08 8b4590 0f57c0 0f1107 8bf4 8945d4 0f114710 }
            // n = 7, score = 100
            //   83ec08               | sub                 esp, 8
            //   8b4590               | mov                 eax, dword ptr [ebp - 0x70]
            //   0f57c0               | xorps               xmm0, xmm0
            //   0f1107               | movups              xmmword ptr [edi], xmm0
            //   8bf4                 | mov                 esi, esp
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   0f114710             | movups              xmmword ptr [edi + 0x10], xmm0

        $sequence_4 = { 83ec18 c645fc03 8bf4 83ec18 8bcc 57 e8???????? }
            // n = 7, score = 100
            //   83ec18               | sub                 esp, 0x18
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8bf4                 | mov                 esi, esp
            //   83ec18               | sub                 esp, 0x18
            //   8bcc                 | mov                 ecx, esp
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_5 = { 894598 89459c 894d94 894da0 8945a4 660fd645a8 894db0 }
            // n = 7, score = 100
            //   894598               | mov                 dword ptr [ebp - 0x68], eax
            //   89459c               | mov                 dword ptr [ebp - 0x64], eax
            //   894d94               | mov                 dword ptr [ebp - 0x6c], ecx
            //   894da0               | mov                 dword ptr [ebp - 0x60], ecx
            //   8945a4               | mov                 dword ptr [ebp - 0x5c], eax
            //   660fd645a8           | movq                qword ptr [ebp - 0x58], xmm0
            //   894db0               | mov                 dword ptr [ebp - 0x50], ecx

        $sequence_6 = { 3d00100000 7227 8d4823 3bc8 0f868d070000 51 e8???????? }
            // n = 7, score = 100
            //   3d00100000           | cmp                 eax, 0x1000
            //   7227                 | jb                  0x29
            //   8d4823               | lea                 ecx, [eax + 0x23]
            //   3bc8                 | cmp                 ecx, eax
            //   0f868d070000         | jbe                 0x793
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_7 = { ffb5bcebffff e8???????? 8b45d4 8bf4 894604 8b45d8 894608 }
            // n = 7, score = 100
            //   ffb5bcebffff         | push                dword ptr [ebp - 0x1444]
            //   e8????????           |                     
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   8bf4                 | mov                 esi, esp
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   894608               | mov                 dword ptr [esi + 8], eax

        $sequence_8 = { 3bca 72b0 7704 3bc3 72aa 8b742410 }
            // n = 6, score = 100
            //   3bca                 | cmp                 ecx, edx
            //   72b0                 | jb                  0xffffffb2
            //   7704                 | ja                  6
            //   3bc3                 | cmp                 eax, ebx
            //   72aa                 | jb                  0xffffffac
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]

        $sequence_9 = { 8d047d02000000 50 ffb5acfeffff 51 e8???????? 8b8db0feffff 83c40c }
            // n = 7, score = 100
            //   8d047d02000000       | lea                 eax, [edi*2 + 2]
            //   50                   | push                eax
            //   ffb5acfeffff         | push                dword ptr [ebp - 0x154]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b8db0feffff         | mov                 ecx, dword ptr [ebp - 0x150]
            //   83c40c               | add                 esp, 0xc

    condition:
        7 of them and filesize < 785408
}