rule win_woolger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.woolger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.woolger"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4508 8b0d???????? 57 52 50 }
            // n = 5, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b0d????????         |                     
            //   57                   | push                edi
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_1 = { 84d2 75f9 8dbdfcf8ffff 2bc1 }
            // n = 4, score = 200
            //   84d2                 | test                dl, dl
            //   75f9                 | jne                 0xfffffffb
            //   8dbdfcf8ffff         | lea                 edi, [ebp - 0x704]
            //   2bc1                 | sub                 eax, ecx

        $sequence_2 = { 6685c0 8d85fcfeffff 50 0f95c3 ff15???????? 8b4f08 }
            // n = 6, score = 200
            //   6685c0               | test                ax, ax
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   0f95c3               | setne               bl
            //   ff15????????         |                     
            //   8b4f08               | mov                 ecx, dword ptr [edi + 8]

        $sequence_3 = { 83c408 85c0 7516 6a01 68???????? }
            // n = 5, score = 200
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18
            //   6a01                 | push                1
            //   68????????           |                     

        $sequence_4 = { be???????? e9???????? 83f80b 750a be???????? e9???????? 83f80d }
            // n = 7, score = 200
            //   be????????           |                     
            //   e9????????           |                     
            //   83f80b               | cmp                 eax, 0xb
            //   750a                 | jne                 0xc
            //   be????????           |                     
            //   e9????????           |                     
            //   83f80d               | cmp                 eax, 0xd

        $sequence_5 = { e8???????? 8d85fcf6ffff 83c40c 8bc8 8a10 40 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8d85fcf6ffff         | lea                 eax, [ebp - 0x904]
            //   83c40c               | add                 esp, 0xc
            //   8bc8                 | mov                 ecx, eax
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax

        $sequence_6 = { 8d85fcfcffff 889508ffffff 898d04ffffff 8bd0 8a08 }
            // n = 5, score = 200
            //   8d85fcfcffff         | lea                 eax, [ebp - 0x304]
            //   889508ffffff         | mov                 byte ptr [ebp - 0xf8], dl
            //   898d04ffffff         | mov                 dword ptr [ebp - 0xfc], ecx
            //   8bd0                 | mov                 edx, eax
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_7 = { 8b450c 3d00010000 740b 3d04010000 0f853b020000 }
            // n = 5, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   3d00010000           | cmp                 eax, 0x100
            //   740b                 | je                  0xd
            //   3d04010000           | cmp                 eax, 0x104
            //   0f853b020000         | jne                 0x241

        $sequence_8 = { 885004 8d85fcfcffff 50 8d8dfcfdffff }
            // n = 4, score = 200
            //   885004               | mov                 byte ptr [eax + 4], dl
            //   8d85fcfcffff         | lea                 eax, [ebp - 0x304]
            //   50                   | push                eax
            //   8d8dfcfdffff         | lea                 ecx, [ebp - 0x204]

        $sequence_9 = { 668945d4 8945d6 8945da 8945de 8945e2 8945e6 8945ea }
            // n = 7, score = 200
            //   668945d4             | mov                 word ptr [ebp - 0x2c], ax
            //   8945d6               | mov                 dword ptr [ebp - 0x2a], eax
            //   8945da               | mov                 dword ptr [ebp - 0x26], eax
            //   8945de               | mov                 dword ptr [ebp - 0x22], eax
            //   8945e2               | mov                 dword ptr [ebp - 0x1e], eax
            //   8945e6               | mov                 dword ptr [ebp - 0x1a], eax
            //   8945ea               | mov                 dword ptr [ebp - 0x16], eax

    condition:
        7 of them and filesize < 196608
}