rule win_xagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xagent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8bd8 e8???????? 03d8 }
            // n = 4, score = 3100
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   03d8                 | add                 ebx, eax

        $sequence_1 = { c1ea02 6bd20d b801000000 2bc2 }
            // n = 4, score = 3100
            //   c1ea02               | shr                 edx, 2
            //   6bd20d               | imul                edx, edx, 0xd
            //   b801000000           | mov                 eax, 1
            //   2bc2                 | sub                 eax, edx

        $sequence_2 = { 57 8b7a08 c1e802 83e103 3bf8 7702 2bc7 }
            // n = 7, score = 2600
            //   57                   | push                edi
            //   8b7a08               | mov                 edi, dword ptr [edx + 8]
            //   c1e802               | shr                 eax, 2
            //   83e103               | and                 ecx, 3
            //   3bf8                 | cmp                 edi, eax
            //   7702                 | ja                  4
            //   2bc7                 | sub                 eax, edi

        $sequence_3 = { 8b0482 8b0488 8b4e10 85c9 7423 8b7e08 }
            // n = 6, score = 2600
            //   8b0482               | mov                 eax, dword ptr [edx + eax*4]
            //   8b0488               | mov                 eax, dword ptr [eax + ecx*4]
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   85c9                 | test                ecx, ecx
            //   7423                 | je                  0x25
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]

        $sequence_4 = { eb02 8b11 8b4808 8bc1 57 8b7a08 }
            // n = 6, score = 2600
            //   eb02                 | jmp                 4
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   8bc1                 | mov                 eax, ecx
            //   57                   | push                edi
            //   8b7a08               | mov                 edi, dword ptr [edx + 8]

        $sequence_5 = { 894e10 7507 c7460c00000000 5f 5e }
            // n = 5, score = 2600
            //   894e10               | mov                 dword ptr [esi + 0x10], ecx
            //   7507                 | jne                 9
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 03ff 3b7e0c 7707 c7460c00000000 49 894e10 7507 }
            // n = 7, score = 2600
            //   03ff                 | add                 edi, edi
            //   3b7e0c               | cmp                 edi, dword ptr [esi + 0xc]
            //   7707                 | ja                  9
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   49                   | dec                 ecx
            //   894e10               | mov                 dword ptr [esi + 0x10], ecx
            //   7507                 | jne                 9

        $sequence_7 = { 7702 2bc7 8b5204 8b0482 8b0488 8b4e10 }
            // n = 6, score = 2600
            //   7702                 | ja                  4
            //   2bc7                 | sub                 eax, edi
            //   8b5204               | mov                 edx, dword ptr [edx + 4]
            //   8b0482               | mov                 eax, dword ptr [edx + eax*4]
            //   8b0488               | mov                 eax, dword ptr [eax + ecx*4]
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]

        $sequence_8 = { 8b7e08 ff460c 03ff 03ff 3b7e0c 7707 }
            // n = 6, score = 2600
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]
            //   ff460c               | inc                 dword ptr [esi + 0xc]
            //   03ff                 | add                 edi, edi
            //   03ff                 | add                 edi, edi
            //   3b7e0c               | cmp                 edi, dword ptr [esi + 0xc]
            //   7707                 | ja                  9

        $sequence_9 = { 8bce e8???????? 8b08 85c9 7504 }
            // n = 5, score = 2600
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   85c9                 | test                ecx, ecx
            //   7504                 | jne                 6

        $sequence_10 = { 740c 488b07 4c8b13 488903 4c8917 488b13 488b0e }
            // n = 7, score = 1500
            //   740c                 | je                  0xe
            //   488b07               | dec                 eax
            //   4c8b13               | mov                 eax, dword ptr [edi]
            //   488903               | dec                 esp
            //   4c8917               | mov                 edx, dword ptr [ebx]
            //   488b13               | dec                 eax
            //   488b0e               | mov                 dword ptr [ebx], eax

        $sequence_11 = { e8???????? 498bce 4e8d0437 482bcf }
            // n = 4, score = 1500
            //   e8????????           |                     
            //   498bce               | mov                 dword ptr [ebx], eax
            //   4e8d0437             | dec                 eax
            //   482bcf               | mov                 dword ptr [edi], ecx

        $sequence_12 = { 384b02 0f92c3 488d4c2430 e8???????? }
            // n = 4, score = 1500
            //   384b02               | dec                 ecx
            //   0f92c3               | mov                 eax, edi
            //   488d4c2430           | mov                 eax, 0xa57eb503
            //   e8????????           |                     

        $sequence_13 = { e8???????? 488b4328 4c8bcf 4c8bc6 }
            // n = 4, score = 1500
            //   e8????????           |                     
            //   488b4328             | je                  0xe
            //   4c8bcf               | dec                 eax
            //   4c8bc6               | mov                 eax, dword ptr [edi]

        $sequence_14 = { e8???????? 48833b00 740a 488b4308 }
            // n = 4, score = 1500
            //   e8????????           |                     
            //   48833b00             | mov                 ecx, dword ptr [esi]
            //   740a                 | test                al, al
            //   488b4308             | je                  0xe

        $sequence_15 = { 4053 4883ec30 488b4118 488bd9 482b4110 }
            // n = 5, score = 1500
            //   4053                 | mul                 esi
            //   4883ec30             | shr                 edx, 6
            //   488b4118             | imul                edx, edx, 0x63
            //   488bd9               | mov                 edx, 0x1f4
            //   482b4110             | dec                 eax

        $sequence_16 = { 8bd8 e8???????? 8d0c18 e8???????? }
            // n = 4, score = 1500
            //   8bd8                 | mov                 ecx, dword ptr [ebx]
            //   e8????????           |                     
            //   8d0c18               | test                al, al
            //   e8????????           |                     

        $sequence_17 = { 84c0 740c 488b07 488b0b 488903 }
            // n = 5, score = 1500
            //   84c0                 | dec                 esp
            //   740c                 | mov                 dword ptr [edi], edx
            //   488b07               | dec                 eax
            //   488b0b               | mov                 edx, dword ptr [ebx]
            //   488903               | dec                 eax

        $sequence_18 = { b803b57ea5 f7e6 c1ea06 6bd263 }
            // n = 4, score = 500
            //   b803b57ea5           | jmp                 6
            //   f7e6                 | xor                 al, al
            //   c1ea06               | cmp                 al, 1
            //   6bd263               | jne                 6

        $sequence_19 = { baf4010000 488bcb ff15???????? 85c0 }
            // n = 4, score = 400
            //   baf4010000           | mov                 al, 1
            //   488bcb               | jmp                 6
            //   ff15????????         |                     
            //   85c0                 | xor                 al, al

        $sequence_20 = { c1ea07 69d295000000 2bca 8bd1 }
            // n = 4, score = 400
            //   c1ea07               | jmp                 6
            //   69d295000000         | xor                 al, al
            //   2bca                 | cmp                 al, 1
            //   8bd1                 | mov                 al, 1

        $sequence_21 = { 75f8 482bc7 488bd6 488d0c38 }
            // n = 4, score = 200
            //   75f8                 | jmp                 6
            //   482bc7               | xor                 al, al
            //   488bd6               | cmp                 al, 1
            //   488d0c38             | jne                 6

        $sequence_22 = { 75f8 482bc7 498bd7 488d0c38 }
            // n = 4, score = 200
            //   75f8                 | jmp                 4
            //   482bc7               | xor                 al, al
            //   498bd7               | cmp                 al, 1
            //   488d0c38             | jne                 6

        $sequence_23 = { 75f8 482bc7 4d8bc6 488bd3 }
            // n = 4, score = 200
            //   75f8                 | shr                 edx, 6
            //   482bc7               | imul                edx, edx, 0x63
            //   4d8bc6               | mov                 edx, 0x1f4
            //   488bd3               | dec                 eax

        $sequence_24 = { 75f8 482bc5 4533e4 488bbc2480000000 4533c9 4c89642430 }
            // n = 6, score = 200
            //   75f8                 | jmp                 4
            //   482bc5               | xor                 al, al
            //   4533e4               | cmp                 al, 1
            //   488bbc2480000000     | mov                 al, 1
            //   4533c9               | jmp                 4
            //   4c89642430           | xor                 al, al

        $sequence_25 = { 75f8 482bc8 448bc1 488bd0 }
            // n = 4, score = 200
            //   75f8                 | mov                 edi, dword ptr [esp + 0x80]
            //   482bc8               | inc                 ebp
            //   448bc1               | xor                 ecx, ecx
            //   488bd0               | dec                 esp

    condition:
        7 of them and filesize < 729088
}