rule win_xbtl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xbtl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xbtl"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c41c 56 e8???????? 83c404 57 e8???????? 8b4df8 }
            // n = 7, score = 100
            //   83c41c               | add                 esp, 0x1c
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_1 = { 83c404 33ff b8???????? 8bd6 897c2420 2bd0 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   33ff                 | xor                 edi, edi
            //   b8????????           |                     
            //   8bd6                 | mov                 edx, esi
            //   897c2420             | mov                 dword ptr [esp + 0x20], edi
            //   2bd0                 | sub                 edx, eax

        $sequence_2 = { 8b4320 8b95e0fcffff 50 8d8df4feffff 68???????? 51 c6047200 }
            // n = 7, score = 100
            //   8b4320               | mov                 eax, dword ptr [ebx + 0x20]
            //   8b95e0fcffff         | mov                 edx, dword ptr [ebp - 0x320]
            //   50                   | push                eax
            //   8d8df4feffff         | lea                 ecx, [ebp - 0x10c]
            //   68????????           |                     
            //   51                   | push                ecx
            //   c6047200             | mov                 byte ptr [edx + esi*2], 0

        $sequence_3 = { 51 52 e8???????? 43 83c40c 89450c 3b5df8 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   43                   | inc                 ebx
            //   83c40c               | add                 esp, 0xc
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   3b5df8               | cmp                 ebx, dword ptr [ebp - 8]

        $sequence_4 = { 85ff 75ef c745fcffffffff 6a01 e8???????? 8bf8 8b4f0c }
            // n = 7, score = 100
            //   85ff                 | test                edi, edi
            //   75ef                 | jne                 0xfffffff1
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   6a01                 | push                1
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]

        $sequence_5 = { 84c0 7429 0fb63e 0fb6c0 eb12 8b45e0 8a803c884100 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   7429                 | je                  0x2b
            //   0fb63e               | movzx               edi, byte ptr [esi]
            //   0fb6c0               | movzx               eax, al
            //   eb12                 | jmp                 0x14
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8a803c884100         | mov                 al, byte ptr [eax + 0x41883c]

        $sequence_6 = { 33d1 03f2 03b4bdb8feffff 8b95b8feffff 8db41ea1ebd96e 8985b0feffff 8b85b4feffff }
            // n = 7, score = 100
            //   33d1                 | xor                 edx, ecx
            //   03f2                 | add                 esi, edx
            //   03b4bdb8feffff       | add                 esi, dword ptr [ebp + edi*4 - 0x148]
            //   8b95b8feffff         | mov                 edx, dword ptr [ebp - 0x148]
            //   8db41ea1ebd96e       | lea                 esi, [esi + ebx + 0x6ed9eba1]
            //   8985b0feffff         | mov                 dword ptr [ebp - 0x150], eax
            //   8b85b4feffff         | mov                 eax, dword ptr [ebp - 0x14c]

        $sequence_7 = { 8985ccfdffff 83f8ff 0f8409020000 8b95d0fdffff 6a00 8d8de8fdffff 51 }
            // n = 7, score = 100
            //   8985ccfdffff         | mov                 dword ptr [ebp - 0x234], eax
            //   83f8ff               | cmp                 eax, -1
            //   0f8409020000         | je                  0x20f
            //   8b95d0fdffff         | mov                 edx, dword ptr [ebp - 0x230]
            //   6a00                 | push                0
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]
            //   51                   | push                ecx

        $sequence_8 = { 50 53 68???????? 68???????? 57 e8???????? 57 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   53                   | push                ebx
            //   68????????           |                     
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_9 = { 7411 8b45f8 57 50 }
            // n = 4, score = 100
            //   7411                 | je                  0x13
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   57                   | push                edi
            //   50                   | push                eax

    condition:
        7 of them and filesize < 401408
}