rule win_zardoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zardoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zardoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 41b85a010000 488d1532a01000 488bcb e8???????? 83c8ff 488b5c2450 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   41b85a010000         | mov                 eax, 0x2e9
            //   488d1532a01000       | dec                 eax
            //   488bcb               | lea                 edx, [0xd626c]
            //   e8????????           |                     
            //   83c8ff               | dec                 eax
            //   488b5c2450           | mov                 esi, ebx

        $sequence_1 = { e8???????? b801000000 eb34 c744242013010000 41b87e000000 eb0e c74424200b010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b801000000           | mov                 dword ptr [ebp - 0x39], eax
            //   eb34                 | mov                 eax, dword ptr [ebp - 0xd]
            //   c744242013010000     | add                 eax, ebx
            //   41b87e000000         | mov                 dword ptr [ebp - 0x35], eax
            //   eb0e                 | dec                 eax
            //   c74424200b010000     | lea                 edx, [ebp - 0x39]

        $sequence_2 = { e8???????? 41b882000000 488d1520da0900 498bcd e8???????? 488b4308 4885c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   41b882000000         | lea                 ecx, [0xbc1d4]
            //   488d1520da0900       | mov                 dword ptr [esp + 0x20], 0x288
            //   498bcd               | dec                 eax
            //   e8????????           |                     
            //   488b4308             | mov                 edi, eax
            //   4885c0               | dec                 eax

        $sequence_3 = { eb38 488b97a0060000 eb28 488d0d9d3f1300 ba02000000 33c0 eb1f }
            // n = 7, score = 100
            //   eb38                 | test                ebp, ebp
            //   488b97a0060000       | je                  0x2c9
            //   eb28                 | add                 dword ptr [esi], ebp
            //   488d0d9d3f1300       | dec                 ecx
            //   ba02000000           | add                 edx, esi
            //   33c0                 | dec                 eax
            //   eb1f                 | cmp                 edi, ebx

        $sequence_4 = { e8???????? e9???????? ba2f000000 c74424285f020000 488d1d81f11200 41b8b3010000 488bcf }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   ba2f000000           | mov                 ecx, dword ptr [edi + 0x768]
            //   c74424285f020000     | dec                 eax
            //   488d1d81f11200       | lea                 ecx, [esp + 0x80]
            //   41b8b3010000         | dec                 eax
            //   488bcf               | add                 ecx, edx

        $sequence_5 = { e8???????? 488bd8 4885c0 7417 488bcf e8???????? 488bfb }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bd8               | dec                 esi
            //   4885c0               | inc                 ecx
            //   7417                 | dec                 ebp
            //   488bcf               | dec                 ecx
            //   e8????????           |                     
            //   488bfb               | mov                 ecx, esp

        $sequence_6 = { e8???????? 41b88b010000 488d1574a60f00 498bcf e8???????? 488b4c2458 488d1578faffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   41b88b010000         | mov                 edx, dword ptr [esi + 8]
            //   488d1574a60f00       | dec                 eax
            //   498bcf               | mov                 edi, eax
            //   e8????????           |                     
            //   488b4c2458           | dec                 eax
            //   488d1578faffff       | test                eax, eax

        $sequence_7 = { ffc6 4883c302 eb95 488b9c2490000000 488bcb e8???????? 4803f8 }
            // n = 7, score = 100
            //   ffc6                 | inc                 esp
            //   4883c302             | mov                 dword ptr [ebp - 0x4c], esp
            //   eb95                 | inc                 esp
            //   488b9c2490000000     | mov                 dword ptr [ebp - 0x44], esp
            //   488bcb               | dec                 esp
            //   e8????????           |                     
            //   4803f8               | mov                 dword ptr [ebp - 0x40], esp

        $sequence_8 = { e8???????? 83c8ff e9???????? 448b8c24a0000000 4183f901 7468 4c8d0522000b00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c8ff               | or                  ebx, 0xffffffff
            //   e9????????           |                     
            //   448b8c24a0000000     | dec                 eax
            //   4183f901             | lea                 edx, [0xffeedc80]
            //   7468                 | dec                 eax
            //   4c8d0522000b00       | mov                 dword ptr [esp + 0x28], ecx

        $sequence_9 = { 488d4904 488d14c8 488b83a8000000 488990e0020000 488b83a8000000 488b8b88040000 488b80e0020000 }
            // n = 7, score = 100
            //   488d4904             | inc                 ecx
            //   488d14c8             | mov                 ecx, edx
            //   488b83a8000000       | shr                 ecx, 1
            //   488990e0020000       | xor                 ecx, eax
            //   488b83a8000000       | inc                 ecx
            //   488b8b88040000       | mov                 eax, ebp
            //   488b80e0020000       | xor                 ecx, dword ptr [esp + 8]

    condition:
        7 of them and filesize < 4376576
}