rule win_zeppelin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeppelin"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3c02 740b 8d45e8 e8???????? }
            // n = 4, score = 400
            //   3c02                 | cmp                 al, 2
            //   740b                 | je                  0xd
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   e8????????           |                     

        $sequence_1 = { 8d55cc b8???????? e8???????? ff75cc 8d55c8 8b4314 e8???????? }
            // n = 7, score = 400
            //   8d55cc               | lea                 edx, [ebp - 0x34]
            //   b8????????           |                     
            //   e8????????           |                     
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   8d55c8               | lea                 edx, [ebp - 0x38]
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   e8????????           |                     

        $sequence_2 = { e8???????? 8d45e0 8b55fc 0fb712 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0fb712               | movzx               edx, word ptr [edx]

        $sequence_3 = { e8???????? 8b55b8 b801000080 59 e8???????? 84c0 7444 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8b55b8               | mov                 edx, dword ptr [ebp - 0x48]
            //   b801000080           | mov                 eax, 0x80000001
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7444                 | je                  0x46

        $sequence_4 = { e8???????? 6800080000 33c9 b201 a1???????? e8???????? 8bf8 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   6800080000           | push                0x800
            //   33c9                 | xor                 ecx, ecx
            //   b201                 | mov                 dl, 1
            //   a1????????           |                     
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { 648910 68???????? 8d45c8 e8???????? 8d45d0 8b15???????? }
            // n = 6, score = 400
            //   648910               | mov                 dword ptr fs:[eax], edx
            //   68????????           |                     
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   e8????????           |                     
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   8b15????????         |                     

        $sequence_6 = { 8b45f4 803830 750b 8b45f4 e8???????? }
            // n = 5, score = 400
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   803830               | cmp                 byte ptr [eax], 0x30
            //   750b                 | jne                 0xd
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   e8????????           |                     

        $sequence_7 = { 53 0fb644240c 50 57 ff15???????? }
            // n = 5, score = 400
            //   53                   | push                ebx
            //   0fb644240c           | movzx               eax, byte ptr [esp + 0xc]
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_8 = { e8???????? 4e 85f6 75cb 8b45ec e8???????? 6a00 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   4e                   | dec                 esi
            //   85f6                 | test                esi, esi
            //   75cb                 | jne                 0xffffffcd
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_9 = { 50 8b442408 50 53 0fb644240c }
            // n = 5, score = 400
            //   50                   | push                eax
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   0fb644240c           | movzx               eax, byte ptr [esp + 0xc]

    condition:
        7 of them and filesize < 2637824
}
