rule elf_bashlite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects elf.bashlite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.bashlite"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 750c c785ecefffff01000000 eb0a c785ecefffff00000000 }
            // n = 5, score = 300
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   c785ecefffff01000000     | mov    dword ptr [ebp - 0x1014], 1
            //   eb0a                 | jmp                 0xc
            //   c785ecefffff00000000     | mov    dword ptr [ebp - 0x1014], 0

        $sequence_1 = { f7d0 21d0 3345fc c9 c3 }
            // n = 5, score = 300
            //   f7d0                 | not                 eax
            //   21d0                 | and                 eax, edx
            //   3345fc               | xor                 eax, dword ptr [ebp - 4]
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_2 = { e8???????? 8945ec 837dec00 750b }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   750b                 | jne                 0xd

        $sequence_3 = { 89c2 89d0 c1e81f 01d0 }
            // n = 4, score = 300
            //   89c2                 | mov                 edx, eax
            //   89d0                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   01d0                 | add                 eax, edx

        $sequence_4 = { 83f8ff 750c e8???????? 8b00 83f873 }
            // n = 5, score = 300
            //   83f8ff               | cmp                 eax, -1
            //   750c                 | jne                 0xe
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   83f873               | cmp                 eax, 0x73

        $sequence_5 = { 760f e8???????? c7001c000000 31c0 }
            // n = 4, score = 300
            //   760f                 | jbe                 0x11
            //   e8????????           |                     
            //   c7001c000000         | mov                 dword ptr [eax], 0x1c
            //   31c0                 | xor                 eax, eax

        $sequence_6 = { eb0a c785ecefffff00000000 8b85ecefffff c9 }
            // n = 4, score = 300
            //   eb0a                 | jmp                 0xc
            //   c785ecefffff00000000     | mov    dword ptr [ebp - 0x1014], 0
            //   8b85ecefffff         | mov                 eax, dword ptr [ebp - 0x1014]
            //   c9                   | leave               

        $sequence_7 = { eb19 e8???????? c70016000000 e8???????? c70016000000 }
            // n = 5, score = 300
            //   eb19                 | jmp                 0x1b
            //   e8????????           |                     
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   e8????????           |                     
            //   c70016000000         | mov                 dword ptr [eax], 0x16

    condition:
        7 of them and filesize < 2310144
}