rule elf_hideandseek_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects elf.hideandseek."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.hideandseek"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740d 83ec0c ff36 e8???????? 83c410 56 56 }
            // n = 7, score = 100
            //   740d                 | je                  0xf
            //   83ec0c               | sub                 esp, 0xc
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_1 = { e8???????? eb09 83ec0c 56 e8???????? 83c410 f7df }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb09                 | jmp                 0xb
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   f7df                 | neg                 edi

        $sequence_2 = { 89c7 85c0 0f8947040000 e9???????? 83be4c01000018 0f87f7040000 8b864c010000 }
            // n = 7, score = 100
            //   89c7                 | mov                 edi, eax
            //   85c0                 | test                eax, eax
            //   0f8947040000         | jns                 0x44d
            //   e9????????           |                     
            //   83be4c01000018       | cmp                 dword ptr [esi + 0x14c], 0x18
            //   0f87f7040000         | ja                  0x4fd
            //   8b864c010000         | mov                 eax, dword ptr [esi + 0x14c]

        $sequence_3 = { 84d2 7410 8a53ff 8d43ff 3a542403 7404 84d2 }
            // n = 7, score = 100
            //   84d2                 | test                dl, dl
            //   7410                 | je                  0x12
            //   8a53ff               | mov                 dl, byte ptr [ebx - 1]
            //   8d43ff               | lea                 eax, [ebx - 1]
            //   3a542403             | cmp                 dl, byte ptr [esp + 3]
            //   7404                 | je                  6
            //   84d2                 | test                dl, dl

        $sequence_4 = { e8???????? 8b35???????? 83c410 8d78f0 eb45 8b442410 31d2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c410               | add                 esp, 0x10
            //   8d78f0               | lea                 edi, [eax - 0x10]
            //   eb45                 | jmp                 0x47
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   31d2                 | xor                 edx, edx

        $sequence_5 = { 31f6 8b5c240c 803d????????00 7532 e8???????? 88c2 89c1 }
            // n = 7, score = 100
            //   31f6                 | xor                 esi, esi
            //   8b5c240c             | mov                 ebx, dword ptr [esp + 0xc]
            //   803d????????00       |                     
            //   7532                 | jne                 0x34
            //   e8????????           |                     
            //   88c2                 | mov                 dl, al
            //   89c1                 | mov                 ecx, eax

        $sequence_6 = { b801000000 83c410 c684331001000000 c7864c0100000b000000 c7863801000000000000 eb09 b803000000 }
            // n = 7, score = 100
            //   b801000000           | mov                 eax, 1
            //   83c410               | add                 esp, 0x10
            //   c684331001000000     | mov                 byte ptr [ebx + esi + 0x110], 0
            //   c7864c0100000b000000     | mov    dword ptr [esi + 0x14c], 0xb
            //   c7863801000000000000     | mov    dword ptr [esi + 0x138], 0
            //   eb09                 | jmp                 0xb
            //   b803000000           | mov                 eax, 3

        $sequence_7 = { e8???????? c7874801000004000000 58 5a 8d84243a010000 50 8d8710010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c7874801000004000000     | mov    dword ptr [edi + 0x148], 4
            //   58                   | pop                 eax
            //   5a                   | pop                 edx
            //   8d84243a010000       | lea                 eax, [esp + 0x13a]
            //   50                   | push                eax
            //   8d8710010000         | lea                 eax, [edi + 0x110]

        $sequence_8 = { c1e806 f7d0 83e001 c3 31c0 c3 8b4c2404 }
            // n = 7, score = 100
            //   c1e806               | shr                 eax, 6
            //   f7d0                 | not                 eax
            //   83e001               | and                 eax, 1
            //   c3                   | ret                 
            //   31c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]

        $sequence_9 = { 5a 85c0 59 0f8f1dffffff 50 8b442454 }
            // n = 6, score = 100
            //   5a                   | pop                 edx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   0f8f1dffffff         | jg                  0xffffff23
            //   50                   | push                eax
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]

    condition:
        7 of them and filesize < 196608
}