rule osx_gmera_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.gmera"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d6de0 48 89df e8???????? 48 }
            // n = 5, score = 200
            //   8d6de0               | lea                 ebp, [ebp - 0x20]
            //   48                   | dec                 eax
            //   89df                 | mov                 edi, ebx
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_1 = { 84c0 7509 48 8d7b08 e8???????? 8a4338 84c0 }
            // n = 7, score = 200
            //   84c0                 | test                al, al
            //   7509                 | jne                 0xb
            //   48                   | dec                 eax
            //   8d7b08               | lea                 edi, [ebx + 8]
            //   e8????????           |                     
            //   8a4338               | mov                 al, byte ptr [ebx + 0x38]
            //   84c0                 | test                al, al

        $sequence_2 = { 83ec18 48 89fb 48 8b3d???????? 48 01df }
            // n = 7, score = 200
            //   83ec18               | sub                 esp, 0x18
            //   48                   | dec                 eax
            //   89fb                 | mov                 ebx, edi
            //   48                   | dec                 eax
            //   8b3d????????         |                     
            //   48                   | dec                 eax
            //   01df                 | add                 edi, ebx

        $sequence_3 = { 48 83ec10 48 8b3d???????? 4c 01ef 31f6 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   83ec10               | sub                 esp, 0x10
            //   48                   | dec                 eax
            //   8b3d????????         |                     
            //   4c                   | dec                 esp
            //   01ef                 | add                 edi, ebp
            //   31f6                 | xor                 esi, esi

        $sequence_4 = { 49 c744c73000000000 4c 8b75d0 }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   c744c73000000000     | mov                 dword ptr [edi + eax*8 + 0x30], 0
            //   4c                   | dec                 esp
            //   8b75d0               | mov                 esi, dword ptr [ebp - 0x30]

        $sequence_5 = { 49 8b3c06 4c 8d6dd0 e8???????? 4c }
            // n = 6, score = 200
            //   49                   | dec                 ecx
            //   8b3c06               | mov                 edi, dword ptr [esi + eax]
            //   4c                   | dec                 esp
            //   8d6dd0               | lea                 ebp, [ebp - 0x30]
            //   e8????????           |                     
            //   4c                   | dec                 esp

        $sequence_6 = { 8b4730 0fb75734 48 83c007 48 bef8ffffff 0100 }
            // n = 7, score = 200
            //   8b4730               | mov                 eax, dword ptr [edi + 0x30]
            //   0fb75734             | movzx               edx, word ptr [edi + 0x34]
            //   48                   | dec                 eax
            //   83c007               | add                 eax, 7
            //   48                   | dec                 eax
            //   bef8ffffff           | mov                 esi, 0xfffffff8
            //   0100                 | add                 dword ptr [eax], eax

        $sequence_7 = { 0100 0000 48 21c1 48 8d045b }
            // n = 6, score = 200
            //   0100                 | add                 dword ptr [eax], eax
            //   0000                 | add                 byte ptr [eax], al
            //   48                   | dec                 eax
            //   21c1                 | and                 ecx, eax
            //   48                   | dec                 eax
            //   8d045b               | lea                 eax, [ebx + ebx*2]

        $sequence_8 = { 89de 4d 89f5 e8???????? 48 }
            // n = 5, score = 200
            //   89de                 | mov                 esi, ebx
            //   4d                   | dec                 ebp
            //   89f5                 | mov                 ebp, esi
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_9 = { 48 8d7de0 31d2 48 }
            // n = 4, score = 200
            //   48                   | dec                 eax
            //   8d7de0               | lea                 edi, [ebp - 0x20]
            //   31d2                 | xor                 edx, edx
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 97248
}