rule osx_keranger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.keranger"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffce 75f1 4c 89f7 48 89de 48 }
            // n = 7, score = 200
            //   ffce                 | dec                 esi
            //   75f1                 | jne                 0xfffffff3
            //   4c                   | dec                 esp
            //   89f7                 | mov                 edi, esi
            //   48                   | dec                 eax
            //   89de                 | mov                 esi, ebx
            //   48                   | dec                 eax

        $sequence_1 = { ffc3 4c 39f3 7ce4 be04000000 4c }
            // n = 6, score = 200
            //   ffc3                 | inc                 ebx
            //   4c                   | dec                 esp
            //   39f3                 | cmp                 ebx, esi
            //   7ce4                 | jl                  0xffffffe6
            //   be04000000           | mov                 esi, 4
            //   4c                   | dec                 esp

        $sequence_2 = { c70600000000 48 8bbd30ffffff 48 85ff 742a 48 }
            // n = 7, score = 200
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   48                   | dec                 eax
            //   8bbd30ffffff         | mov                 edi, dword ptr [ebp - 0xd0]
            //   48                   | dec                 eax
            //   85ff                 | test                edi, edi
            //   742a                 | je                  0x2c
            //   48                   | dec                 eax

        $sequence_3 = { 31c0 45 31c9 e8???????? e9???????? 85c0 }
            // n = 6, score = 200
            //   31c0                 | xor                 eax, eax
            //   45                   | inc                 ebp
            //   31c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   e9????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_4 = { c7432010270000 48 8d75b0 ba???????? 4c 89f7 e8???????? }
            // n = 7, score = 200
            //   c7432010270000       | mov                 dword ptr [ebx + 0x20], 0x2710
            //   48                   | dec                 eax
            //   8d75b0               | lea                 esi, [ebp - 0x50]
            //   ba????????           |                     
            //   4c                   | dec                 esp
            //   89f7                 | mov                 edi, esi
            //   e8????????           |                     

        $sequence_5 = { 8954f534 41 3354f518 41 8954f538 41 3354f51c }
            // n = 7, score = 200
            //   8954f534             | mov                 dword ptr [ebp + esi*8 + 0x34], edx
            //   41                   | inc                 ecx
            //   3354f518             | xor                 edx, dword ptr [ebp + esi*8 + 0x18]
            //   41                   | inc                 ecx
            //   8954f538             | mov                 dword ptr [ebp + esi*8 + 0x38], edx
            //   41                   | inc                 ecx
            //   3354f51c             | xor                 edx, dword ptr [ebp + esi*8 + 0x1c]

        $sequence_6 = { 48 8d75c0 4c 89e1 e8???????? 89c3 85db }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   8d75c0               | lea                 esi, [ebp - 0x40]
            //   4c                   | dec                 esp
            //   89e1                 | mov                 ecx, esp
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx

        $sequence_7 = { e9???????? 31c9 e9???????? 49 8b7d08 4c 89e6 }
            // n = 7, score = 200
            //   e9????????           |                     
            //   31c9                 | xor                 ecx, ecx
            //   e9????????           |                     
            //   49                   | dec                 ecx
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   4c                   | dec                 esp
            //   89e6                 | mov                 esi, esp

        $sequence_8 = { 0f95c0 44 20f0 0fb6d0 48 8db5d0feffff 4c }
            // n = 7, score = 200
            //   0f95c0               | setne               al
            //   44                   | inc                 esp
            //   20f0                 | and                 al, dh
            //   0fb6d0               | movzx               edx, al
            //   48                   | dec                 eax
            //   8db5d0feffff         | lea                 esi, [ebp - 0x130]
            //   4c                   | dec                 esp

        $sequence_9 = { c1c30e 45 01fb c1c30a 44 89d9 21d9 }
            // n = 7, score = 200
            //   c1c30e               | rol                 ebx, 0xe
            //   45                   | inc                 ebp
            //   01fb                 | add                 ebx, edi
            //   c1c30a               | rol                 ebx, 0xa
            //   44                   | inc                 esp
            //   89d9                 | mov                 ecx, ebx
            //   21d9                 | and                 ecx, ebx

    condition:
        7 of them and filesize < 609024
}