rule osx_oceanlotus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.oceanlotus"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 8b85f0feffff 48 8d78e8 48 3b3d???????? 7417 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   8b85f0feffff         | mov                 eax, dword ptr [ebp - 0x110]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]
            //   48                   | dec                 eax
            //   3b3d????????         |                     
            //   7417                 | je                  0x19

        $sequence_1 = { 8b85b8fdffff 48 8d78e8 48 3b3d???????? }
            // n = 5, score = 200
            //   8b85b8fdffff         | mov                 eax, dword ptr [ebp - 0x248]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]
            //   48                   | dec                 eax
            //   3b3d????????         |                     

        $sequence_2 = { 48 8b85b8fdffff 48 8d78e8 48 }
            // n = 5, score = 200
            //   48                   | dec                 eax
            //   8b85b8fdffff         | mov                 eax, dword ptr [ebp - 0x248]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]
            //   48                   | dec                 eax

        $sequence_3 = { 8b85b8fdffff 48 8d78e8 48 }
            // n = 4, score = 200
            //   8b85b8fdffff         | mov                 eax, dword ptr [ebp - 0x248]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]
            //   48                   | dec                 eax

        $sequence_4 = { 8b85f0feffff 48 8d78e8 48 3b3d???????? 7417 }
            // n = 6, score = 200
            //   8b85f0feffff         | mov                 eax, dword ptr [ebp - 0x110]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]
            //   48                   | dec                 eax
            //   3b3d????????         |                     
            //   7417                 | je                  0x19

        $sequence_5 = { e8???????? 48 8b85f8feffff 48 8d78e8 48 3b3d???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b85f8feffff         | mov                 eax, dword ptr [ebp - 0x108]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]
            //   48                   | dec                 eax
            //   3b3d????????         |                     

        $sequence_6 = { 89de e8???????? 48 8b8508ffffff 48 8d78e8 }
            // n = 6, score = 200
            //   89de                 | mov                 esi, ebx
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b8508ffffff         | mov                 eax, dword ptr [ebp - 0xf8]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]

        $sequence_7 = { e8???????? 48 8b85f8feffff 48 8d78e8 48 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b85f8feffff         | mov                 eax, dword ptr [ebp - 0x108]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]
            //   48                   | dec                 eax

        $sequence_8 = { 48 89de e8???????? 48 8b8508ffffff 48 8d78e8 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   89de                 | mov                 esi, ebx
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b8508ffffff         | mov                 eax, dword ptr [ebp - 0xf8]
            //   48                   | dec                 eax
            //   8d78e8               | lea                 edi, [eax - 0x18]

        $sequence_9 = { 90 55 48 89e5 5d e9???????? }
            // n = 6, score = 200
            //   90                   | nop                 
            //   55                   | push                ebp
            //   48                   | dec                 eax
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   e9????????           |                     

    condition:
        7 of them and filesize < 308528
}