rule win_3cx_backdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.3cx_backdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.3cx_backdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d442420 488d4d98 e8???????? 488bf8 488d542478 498bce e8???????? }
            // n = 7, score = 100
            //   4c8d442420           | ja                  0x1fc1
            //   488d4d98             | dec                 esp
            //   e8????????           |                     
            //   488bf8               | mov                 dword ptr [ebp - 0x38], edi
            //   488d542478           | movdqu              xmmword ptr [ebp - 0x28], xmm0
            //   498bce               | mov                 byte ptr [ebp - 0x38], 0
            //   e8????????           |                     

        $sequence_1 = { 488b4d8f 4c8d05b77c0300 41b920000000 c744242000000000 488d15c27c0300 ff15???????? }
            // n = 6, score = 100
            //   488b4d8f             | dec                 eax
            //   4c8d05b77c0300       | lea                 ecx, [ebp + 0x58]
            //   41b920000000         | je                  0x513
            //   c744242000000000     | dec                 eax
            //   488d15c27c0300       | mov                 ecx, dword ptr [ecx + 0x10]
            //   ff15????????         |                     

        $sequence_2 = { 41b8ffffffff 488bd6 ff15???????? ba25000000 8d4a1b }
            // n = 5, score = 100
            //   41b8ffffffff         | mov                 dword ptr [esp + 0x20], ebx
            //   488bd6               | nop                 
            //   ff15????????         |                     
            //   ba25000000           | dec                 eax
            //   8d4a1b               | lea                 ecx, [ebx + 0x40]

        $sequence_3 = { 0f87ff010000 c1e60a 81c60024a0fc 03f0 eb11 8d860024ffff }
            // n = 6, score = 100
            //   0f87ff010000         | jne                 0x10
            //   c1e60a               | dec                 eax
            //   81c60024a0fc         | add                 eax, ecx
            //   03f0                 | dec                 eax
            //   eb11                 | mov                 dword ptr [esp + 0x40], ecx
            //   8d860024ffff         | dec                 eax

        $sequence_4 = { 488bd7 498bcd e8???????? 498bc4 4c8d5c2450 498b5b40 }
            // n = 6, score = 100
            //   488bd7               | mov                 al, 1
            //   498bcd               | dec                 eax
            //   e8????????           |                     
            //   498bc4               | mov                 ecx, dword ptr [ebp + 0x37]
            //   4c8d5c2450           | dec                 eax
            //   498b5b40             | xor                 ecx, esp

        $sequence_5 = { 488d0547ac0100 4a8b04f8 42f644e83801 7515 e8???????? c70009000000 e8???????? }
            // n = 7, score = 100
            //   488d0547ac0100       | dec                 eax
            //   4a8b04f8             | mov                 dword ptr [ebp - 0x50], eax
            //   42f644e83801         | dec                 eax
            //   7515                 | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     
            //   c70009000000         | movups              xmmword ptr [esp + 0x60], xmm0
            //   e8????????           |                     

        $sequence_6 = { 7424 488b4308 44386019 7515 6690 483b5810 750d }
            // n = 7, score = 100
            //   7424                 | inc                 ecx
            //   488b4308             | push                esi
            //   44386019             | dec                 eax
            //   7515                 | sub                 esp, 0x30
            //   6690                 | mov                 ebp, edx
            //   483b5810             | dec                 eax
            //   750d                 | mov                 edi, ecx

        $sequence_7 = { 488bc8 e8???????? 4889751f 4889752f 48897537 }
            // n = 5, score = 100
            //   488bc8               | and                 ecx, 0xf
            //   e8????????           |                     
            //   4889751f             | dec                 edx
            //   4889752f             | movsx               eax, byte ptr [ecx + esi + 0x32540]
            //   48897537             | inc                 edx

        $sequence_8 = { e8???????? 85c0 0f85cd100000 e9???????? 4c8d050bae0000 ebdb 4c8d05faad0000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   0f85cd100000         | cmovb               eax, edx
            //   e9????????           |                     
            //   4c8d050bae0000       | dec                 ecx
            //   ebdb                 | mov                 edx, ecx
            //   4c8d05faad0000       | test                eax, eax

        $sequence_9 = { 83b96804000002 0f8406020000 bd20000000 4c8d35e1510100 488b4310 }
            // n = 5, score = 100
            //   83b96804000002       | dec                 eax
            //   0f8406020000         | mov                 eax, edi
            //   bd20000000           | dec                 eax
            //   4c8d35e1510100       | mov                 edx, esi
            //   488b4310             | dec                 ebp

    condition:
        7 of them and filesize < 585728
}