rule win_7ev3n_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.7ev3n."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.7ev3n"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 8d85f0d9ffff 50 8d8dd0cdffff e8???????? 8bce 2bcf }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d85f0d9ffff         | lea                 eax, [ebp - 0x2610]
            //   50                   | push                eax
            //   8d8dd0cdffff         | lea                 ecx, [ebp - 0x3230]
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   2bcf                 | sub                 ecx, edi

        $sequence_1 = { 2bcf 3bc1 0f84e2910000 8dbd50dcffff 8d4f02 0f1f840000000000 }
            // n = 6, score = 100
            //   2bcf                 | sub                 ecx, edi
            //   3bc1                 | cmp                 eax, ecx
            //   0f84e2910000         | je                  0x91e8
            //   8dbd50dcffff         | lea                 edi, [ebp - 0x23b0]
            //   8d4f02               | lea                 ecx, [edi + 2]
            //   0f1f840000000000     | nop                 dword ptr [eax + eax]

        $sequence_2 = { 2bcf 3bc1 0f8412490000 8dbdcce7ffff 8d4f02 0f1f840000000000 668b07 }
            // n = 7, score = 100
            //   2bcf                 | sub                 ecx, edi
            //   3bc1                 | cmp                 eax, ecx
            //   0f8412490000         | je                  0x4918
            //   8dbdcce7ffff         | lea                 edi, [ebp - 0x1834]
            //   8d4f02               | lea                 ecx, [edi + 2]
            //   0f1f840000000000     | nop                 dword ptr [eax + eax]
            //   668b07               | mov                 ax, word ptr [edi]

        $sequence_3 = { e8???????? 8bce 2b8d00cbffff 3bc1 0f84ce070000 8dbd50d9ffff 8d4f02 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   2b8d00cbffff         | sub                 ecx, dword ptr [ebp - 0x3500]
            //   3bc1                 | cmp                 eax, ecx
            //   0f84ce070000         | je                  0x7d4
            //   8dbd50d9ffff         | lea                 edi, [ebp - 0x26b0]
            //   8d4f02               | lea                 ecx, [edi + 2]

        $sequence_4 = { e8???????? 8bce 2bcf 3bc1 0f84427a0000 8dbdf8eeffff 8d4f02 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   2bcf                 | sub                 ecx, edi
            //   3bc1                 | cmp                 eax, ecx
            //   0f84427a0000         | je                  0x7a48
            //   8dbdf8eeffff         | lea                 edi, [ebp - 0x1108]
            //   8d4f02               | lea                 ecx, [edi + 2]

        $sequence_5 = { 6a00 8d85a0e3ffff 50 8d8dd0cdffff e8???????? 8bce 2bcf }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d85a0e3ffff         | lea                 eax, [ebp - 0x1c60]
            //   50                   | push                eax
            //   8d8dd0cdffff         | lea                 ecx, [ebp - 0x3230]
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   2bcf                 | sub                 ecx, edi

        $sequence_6 = { 6a00 6800000080 50 ff15???????? 898520ffffff 85c0 7509 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6800000080           | push                0x80000000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   898520ffffff         | mov                 dword ptr [ebp - 0xe0], eax
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb

        $sequence_7 = { 83c702 6685c0 75f5 2bf9 d1ff 6a00 8d8500edffff }
            // n = 7, score = 100
            //   83c702               | add                 edi, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   2bf9                 | sub                 edi, ecx
            //   d1ff                 | sar                 edi, 1
            //   6a00                 | push                0
            //   8d8500edffff         | lea                 eax, [ebp - 0x1300]

        $sequence_8 = { f30f7e05???????? 660fd68564e6ffff 0fb705???????? 6689856ce6ffff f30f7e05???????? 660fd68558e6ffff 0fb705???????? }
            // n = 7, score = 100
            //   f30f7e05????????     |                     
            //   660fd68564e6ffff     | movq                qword ptr [ebp - 0x199c], xmm0
            //   0fb705????????       |                     
            //   6689856ce6ffff       | mov                 word ptr [ebp - 0x1994], ax
            //   f30f7e05????????     |                     
            //   660fd68558e6ffff     | movq                qword ptr [ebp - 0x19a8], xmm0
            //   0fb705????????       |                     

        $sequence_9 = { d1ff 6a00 8d85acfbffff 50 8d8dd0cdffff e8???????? 8bce }
            // n = 7, score = 100
            //   d1ff                 | sar                 edi, 1
            //   6a00                 | push                0
            //   8d85acfbffff         | lea                 eax, [ebp - 0x454]
            //   50                   | push                eax
            //   8d8dd0cdffff         | lea                 ecx, [ebp - 0x3230]
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi

    condition:
        7 of them and filesize < 803840
}