rule win_8t_dropper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.8t_dropper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.8t_dropper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c644240c00 f3ab 66ab aa bf???????? 83c9ff }
            // n = 6, score = 200
            //   c644240c00           | mov                 byte ptr [esp + 0xc], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_1 = { 8d4c2408 51 683f000f00 50 52 6801000080 }
            // n = 6, score = 200
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   51                   | push                ecx
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax
            //   52                   | push                edx
            //   6801000080           | push                0x80000001

        $sequence_2 = { 8bf0 83c408 85f6 741b 56 6800700000 6a01 }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   741b                 | je                  0x1d
            //   56                   | push                esi
            //   6800700000           | push                0x7000
            //   6a01                 | push                1

        $sequence_3 = { c6440c0d75 c6440c0e6e 8d4c2408 51 683f000f00 50 52 }
            // n = 7, score = 200
            //   c6440c0d75           | mov                 byte ptr [esp + ecx + 0xd], 0x75
            //   c6440c0e6e           | mov                 byte ptr [esp + ecx + 0xe], 0x6e
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   51                   | push                ecx
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax
            //   52                   | push                edx

        $sequence_4 = { 85c0 7559 8b4c2408 51 ff15???????? 8d942410010000 6804010000 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7559                 | jne                 0x5b
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d942410010000       | lea                 edx, [esp + 0x110]
            //   6804010000           | push                0x104

        $sequence_5 = { 8b442418 68???????? 50 ff15???????? 85c0 7559 8b4c2408 }
            // n = 7, score = 200
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7559                 | jne                 0x5b
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]

        $sequence_6 = { 7559 8b4c2408 51 ff15???????? 8d942410010000 }
            // n = 5, score = 200
            //   7559                 | jne                 0x5b
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d942410010000       | lea                 edx, [esp + 0x110]

        $sequence_7 = { c6440c0e6e 8d4c2408 51 683f000f00 50 }
            // n = 5, score = 200
            //   c6440c0e6e           | mov                 byte ptr [esp + ecx + 0xe], 0x6e
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   51                   | push                ecx
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax

        $sequence_8 = { 51 ff15???????? 8d942410010000 6804010000 }
            // n = 4, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d942410010000       | lea                 edx, [esp + 0x110]
            //   6804010000           | push                0x104

        $sequence_9 = { f7d1 49 c6440c0c52 c6440c0d75 c6440c0e6e 8d4c2408 }
            // n = 6, score = 200
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   c6440c0c52           | mov                 byte ptr [esp + ecx + 0xc], 0x52
            //   c6440c0d75           | mov                 byte ptr [esp + ecx + 0xd], 0x75
            //   c6440c0e6e           | mov                 byte ptr [esp + ecx + 0xe], 0x6e
            //   8d4c2408             | lea                 ecx, [esp + 8]

    condition:
        7 of them and filesize < 147456
}