rule win_abcsync_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.abcsync."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.abcsync"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b15???????? 41be2c010000 33c9 458bc6 ff15???????? 488b15???????? 4533e4 }
            // n = 7, score = 100
            //   488b15????????       |                     
            //   41be2c010000         | imul                eax
            //   33c9                 | sar                 edx, 4
            //   458bc6               | dec                 esp
            //   ff15????????         |                     
            //   488b15????????       |                     
            //   4533e4               | lea                 ecx, [eax + 2]

        $sequence_1 = { 8d4108 410fb64c1a07 4898 422a0c18 b81f85eb51 }
            // n = 5, score = 100
            //   8d4108               | inc                 ebx
            //   410fb64c1a07         | lea                 ecx, [ecx + ecx]
            //   4898                 | inc                 ecx
            //   422a0c18             | mov                 eax, 1
            //   b81f85eb51           | test                ecx, ecx

        $sequence_2 = { ba01000000 85c9 7e13 8bc1 0f1f840000000000 c1e204 }
            // n = 6, score = 100
            //   ba01000000           | mov                 ecx, ecx
            //   85c9                 | sar                 edx, 4
            //   7e13                 | mov                 eax, edx
            //   8bc1                 | inc                 ecx
            //   0f1f840000000000     | mov                 byte ptr [edx - 4], cl
            //   c1e204               | inc                 ecx

        $sequence_3 = { 4c63c2 488bcb 33d2 e8???????? 8b542454 418bfc 4c8b35???????? }
            // n = 7, score = 100
            //   4c63c2               | je                  0xa84
            //   488bcb               | dec                 eax
            //   33d2                 | mov                 ecx, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   8b542454             | dec                 eax
            //   418bfc               | lea                 edx, [0xa37a]
            //   4c8b35????????       |                     

        $sequence_4 = { 488d4c2420 c74424205c595f6a c74424245c653601 e8???????? 488905???????? 488b4c2428 }
            // n = 6, score = 100
            //   488d4c2420           | shr                 eax, 0x1f
            //   c74424205c595f6a     | add                 edx, eax
            //   c74424245c653601     | imul                eax, edx, 0x32
            //   e8????????           |                     
            //   488905????????       |                     
            //   488b4c2428           | sub                 ecx, eax

        $sequence_5 = { 2bc8 8d411c 4898 420fb60c18 410fb7441a36 662bc1 418d491d }
            // n = 7, score = 100
            //   2bc8                 | xor                 eax, esp
            //   8d411c               | dec                 eax
            //   4898                 | mov                 dword ptr [esp + 0x30], eax
            //   420fb60c18           | dec                 eax
            //   410fb7441a36         | lea                 ecx, [esp + 0x20]
            //   662bc1               | mov                 dword ptr [esp + 0x20], 0x4c655d4d
            //   418d491d             | mov                 dword ptr [esp + 0x24], 0x667c7367

        $sequence_6 = { 488d057d3b0100 488945e0 895128 488d0d17950000 488b45d8 488908 488d0d69200100 }
            // n = 7, score = 100
            //   488d057d3b0100       | mov                 eax, edx
            //   488945e0             | dec                 eax
            //   895128               | add                 esp, 0x20
            //   488d0d17950000       | sub                 ax, cx
            //   488b45d8             | inc                 cx
            //   488908               | mov                 dword ptr [edx - 4], eax
            //   488d0d69200100       | inc                 ecx

        $sequence_7 = { 75d4 0f1101 498bd1 0f114110 0f114120 0f114130 0f114140 }
            // n = 7, score = 100
            //   75d4                 | sub                 ecx, eax
            //   0f1101               | lea                 eax, [ecx + 6]
            //   498bd1               | inc                 edx
            //   0f114110             | movzx               ecx, byte ptr [ebx + edx + 5]
            //   0f114120             | shr                 eax, 0x1f
            //   0f114130             | add                 edx, eax
            //   0f114140             | imul                eax, edx, 0x32

        $sequence_8 = { 03d0 6bc232 2bc8 8d4116 420fb64c13fb 4898 422a0c18 }
            // n = 7, score = 100
            //   03d0                 | dec                 eax
            //   6bc232               | add                 edx, edi
            //   2bc8                 | dec                 eax
            //   8d4116               | mov                 dword ptr [esp + 0x20], eax
            //   420fb64c13fb         | inc                 ebp
            //   4898                 | xor                 ecx, ecx
            //   422a0c18             | inc                 esp

        $sequence_9 = { 2bc8 8d4121 420fb64c13fe 4898 422a0c18 }
            // n = 5, score = 100
            //   2bc8                 | dec                 eax
            //   8d4121               | cmp                 ebx, eax
            //   420fb64c13fe         | je                  0x10a7
            //   4898                 | je                  0x10b8
            //   422a0c18             | add                 edi, dword ptr [esp + 0x50]

    condition:
        7 of them and filesize < 348160
}