rule win_absentloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.absentloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.absentloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 50 8bce e8???????? 834dfcff 8d85f0f9ffff 50 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8d85f0f9ffff         | lea                 eax, [ebp - 0x610]
            //   50                   | push                eax

        $sequence_1 = { 8b08 8bc3 2bc1 c1f804 3bf0 7238 }
            // n = 6, score = 200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8bc3                 | mov                 eax, ebx
            //   2bc1                 | sub                 eax, ecx
            //   c1f804               | sar                 eax, 4
            //   3bf0                 | cmp                 esi, eax
            //   7238                 | jb                  0x3a

        $sequence_2 = { 5e 8b448dd8 83e825 6bc033 99 f7fe }
            // n = 6, score = 200
            //   5e                   | pop                 esi
            //   8b448dd8             | mov                 eax, dword ptr [ebp + ecx*4 - 0x28]
            //   83e825               | sub                 eax, 0x25
            //   6bc033               | imul                eax, eax, 0x33
            //   99                   | cdq                 
            //   f7fe                 | idiv                esi

        $sequence_3 = { 6a7f 0f1145dc c745ec59000000 5f 6a32 58 2b448ddc }
            // n = 7, score = 200
            //   6a7f                 | push                0x7f
            //   0f1145dc             | movups              xmmword ptr [ebp - 0x24], xmm0
            //   c745ec59000000       | mov                 dword ptr [ebp - 0x14], 0x59
            //   5f                   | pop                 edi
            //   6a32                 | push                0x32
            //   58                   | pop                 eax
            //   2b448ddc             | sub                 eax, dword ptr [ebp + ecx*4 - 0x24]

        $sequence_4 = { 48 a3???????? ff15???????? 8b0d???????? 89048db09506fd 5d c3 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   a3????????           |                     
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   89048db09506fd       | mov                 dword ptr [ecx*4 - 0x2f96a50], eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_5 = { 68087905fd 68007905fd 68087905fd 6a06 e8???????? 8bf0 }
            // n = 6, score = 200
            //   68087905fd           | push                0xfd057908
            //   68007905fd           | push                0xfd057900
            //   68087905fd           | push                0xfd057908
            //   6a06                 | push                6
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { e8???????? 83ec18 c645fc07 8bcc 68a8f905fd 895910 c741140f000000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   8bcc                 | mov                 ecx, esp
            //   68a8f905fd           | push                0xfd05f9a8
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf

        $sequence_7 = { 8b08 bfc8aa06fd 0f2805???????? a1???????? 0f1145dc c745ec0e5a410e }
            // n = 6, score = 200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   bfc8aa06fd           | mov                 edi, 0xfd06aac8
            //   0f2805????????       |                     
            //   a1????????           |                     
            //   0f1145dc             | movups              xmmword ptr [ebp - 0x24], xmm0
            //   c745ec0e5a410e       | mov                 dword ptr [ebp - 0x14], 0xe415a0e

        $sequence_8 = { 40 83f80e 72f6 8bc1 c3 80791300 740c }
            // n = 7, score = 200
            //   40                   | inc                 eax
            //   83f80e               | cmp                 eax, 0xe
            //   72f6                 | jb                  0xfffffff8
            //   8bc1                 | mov                 eax, ecx
            //   c3                   | ret                 
            //   80791300             | cmp                 byte ptr [ecx + 0x13], 0
            //   740c                 | je                  0xe

        $sequence_9 = { 57 bf88a706fd 8d75e8 689f0705fd a5 a5 }
            // n = 6, score = 200
            //   57                   | push                edi
            //   bf88a706fd           | mov                 edi, 0xfd06a788
            //   8d75e8               | lea                 esi, [ebp - 0x18]
            //   689f0705fd           | push                0xfd05079f
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

    condition:
        7 of them and filesize < 794624
}