rule win_acehash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.acehash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acehash"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8455010000 0fb61438 440fb607 458be5 8bc2 418bf0 83e23f }
            // n = 7, score = 200
            //   0f8455010000         | dec                 eax
            //   0fb61438             | mov                 edx, dword ptr [edx + ecx*8 + 0x381b0]
            //   440fb607             | dec                 eax
            //   458be5               | lea                 ecx, [0xffff539a]
            //   8bc2                 | inc                 ecx
            //   418bf0               | and                 esp, 7
            //   83e23f               | inc                 edx

        $sequence_1 = { 8d048504000000 4863d0 e8???????? 488bd8 4885c0 0f849d010000 }
            // n = 6, score = 200
            //   8d048504000000       | imul                eax, ebx
            //   4863d0               | inc                 ecx
            //   e8????????           |                     
            //   488bd8               | imul                edx, edx
            //   4885c0               | rol                 edx, 5
            //   0f849d010000         | rol                 eax, 5

        $sequence_2 = { 83fa08 7410 b803000000 488b5c2430 4883c420 5f c3 }
            // n = 7, score = 200
            //   83fa08               | dec                 eax
            //   7410                 | add                 edx, 0x2c
            //   b803000000           | inc                 esp
            //   488b5c2430           | mov                 eax, dword ptr [esi + 0x30]
            //   4883c420             | dec                 eax
            //   5f                   | mov                 edx, esi
            //   c3                   | dec                 eax

        $sequence_3 = { 33d2 f77304 8bfa 4c89642450 85ff 0f84f0000000 4533e4 }
            // n = 7, score = 200
            //   33d2                 | mov                 ecx, dword ptr [edi + 0x38]
            //   f77304               | inc                 esp
            //   8bfa                 | mov                 eax, ebx
            //   4c89642450           | dec                 ecx
            //   85ff                 | sub                 eax, dword ptr [esi + 0x38]
            //   0f84f0000000         | dec                 eax
            //   4533e4               | add                 edx, eax

        $sequence_4 = { 4403848ea0dd0300 8b4b70 44338486a0e10300 8b4330 4533d0 458d0c02 41d3c1 }
            // n = 7, score = 200
            //   4403848ea0dd0300     | mov                 esi, 0xe3
            //   8b4b70               | dec                 esp
            //   44338486a0e10300     | lea                 esi, [0x33e86]
            //   8b4330               | lea                 eax, [esi + edi]
            //   4533d0               | dec                 eax
            //   458d0c02             | sub                 esp, 0x20
            //   41d3c1               | dec                 eax

        $sequence_5 = { 4889742448 48897c2418 0fb6790c 41c1e208 440bd0 0fb64105 c1e708 }
            // n = 7, score = 200
            //   4889742448           | dec                 eax
            //   48897c2418           | lea                 ebx, [0x3629f]
            //   0fb6790c             | dec                 eax
            //   41c1e208             | lea                 edi, [0x36298]
            //   440bd0               | jmp                 0x1c41
            //   0fb64105             | dec                 eax
            //   c1e708               | mov                 eax, dword ptr [ebx]

        $sequence_6 = { 488d0de8030300 4883c204 48c1fa02 482bd3 e8???????? 448b4608 488bd6 }
            // n = 7, score = 200
            //   488d0de8030300       | dec                 ebp
            //   4883c204             | test                esp, esp
            //   48c1fa02             | inc                 ecx
            //   482bd3               | cmovne              ebp, ebp
            //   e8????????           |                     
            //   448b4608             | sub                 ebp, 0x1000
            //   488bd6               | mov                 dword ptr [ecx + eax*4 + 4], ebp

        $sequence_7 = { e8???????? b9002a0b00 e8???????? 488bf8 4c8bc0 488d1586a80500 488bca }
            // n = 7, score = 200
            //   e8????????           |                     
            //   b9002a0b00           | test                eax, eax
            //   e8????????           |                     
            //   488bf8               | jne                 0x1fd
            //   4c8bc0               | dec                 esp
            //   488d1586a80500       | lea                 esi, [0xf83ba]
            //   488bca               | inc                 ecx

        $sequence_8 = { 4133bc8f709d0400 c1e818 0fb6c8 410fb6c0 4133bc8f70950400 4133bc8770a50400 418bc0 }
            // n = 7, score = 200
            //   4133bc8f709d0400     | inc                 ebp
            //   c1e818               | imul                esp, edx
            //   0fb6c8               | inc                 ecx
            //   410fb6c0             | imul                eax, eax
            //   4133bc8f70950400     | rol                 eax, 5
            //   4133bc8770a50400     | inc                 ecx
            //   418bc0               | rol                 esp, 5

        $sequence_9 = { 438b8cb9a0f10300 41338cb9a0ed0300 41338cb1a0e50300 41338c81a0f10300 33ca 334daf 8bc1 }
            // n = 7, score = 200
            //   438b8cb9a0f10300     | lea                 edi, [0xf6c04]
            //   41338cb9a0ed0300     | dec                 eax
            //   41338cb1a0e50300     | add                 ebx, ebx
            //   41338c81a0f10300     | dec                 eax
            //   33ca                 | cmp                 dword ptr [edi + ebx*8], 0
            //   334daf               | jne                 0x58
            //   8bc1                 | dec                 eax

    condition:
        7 of them and filesize < 2318336
}