rule win_acidbox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.acidbox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acidbox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 89442430 85c0 0f841a010000 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   89442430             | mov                 edx, esi
            //   85c0                 | dec                 eax
            //   0f841a010000         | mov                 ecx, esi

        $sequence_1 = { 33d2 e9???????? 41c1ee04 33d2 83c6fc 418bce 83e10f }
            // n = 7, score = 400
            //   33d2                 | mov                 dword ptr [eax - 0x18], ebx
            //   e9????????           |                     
            //   41c1ee04             | mov                 dword ptr [eax - 0x20], 0x80
            //   33d2                 | dec                 eax
            //   83c6fc               | test                ecx, ecx
            //   418bce               | je                  0x48f
            //   83e10f               | jne                 0x438

        $sequence_2 = { 488bce e8???????? 397e18 750b 834b40ff 33c0 e9???????? }
            // n = 7, score = 400
            //   488bce               | test                edi, edi
            //   e8????????           |                     
            //   397e18               | je                  0xfc6
            //   750b                 | dec                 eax
            //   834b40ff             | cmp                 dword ptr [ecx + 0x10], edx
            //   33c0                 | je                  0xfc6
            //   e9????????           |                     

        $sequence_3 = { 48895c2408 57 4883ec30 488bfa 33db 4885c9 7479 }
            // n = 7, score = 400
            //   48895c2408           | dec                 ecx
            //   57                   | mov                 ecx, esi
            //   4883ec30             | cmp                 ebx, 1
            //   488bfa               | jne                 0x62d
            //   33db                 | dec                 ecx
            //   4885c9               | mov                 eax, dword ptr [esi + 0x170]
            //   7479                 | dec                 eax

        $sequence_4 = { 4883ec58 488bf1 bf01200480 8978a8 33db 48895818 448bf3 }
            // n = 7, score = 400
            //   4883ec58             | lea                 edx, [ebx + 1]
            //   488bf1               | inc                 ebp
            //   bf01200480           | xor                 eax, eax
            //   8978a8               | dec                 eax
            //   33db                 | lea                 edx, [esp + 0x140]
            //   48895818             | dec                 eax
            //   448bf3               | lea                 edx, [eax + 8]

        $sequence_5 = { e8???????? 3b4704 7513 4d897500 8b4708 33db 418907 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   3b4704               | je                  0x197
            //   7513                 | dec                 ecx
            //   4d897500             | je                  0x21e
            //   8b4708               | dec                 ecx
            //   33db                 | je                  0x332
            //   418907               | cmp                 ecx, 4

        $sequence_6 = { 4d85f6 741a 33d2 41b880010000 498bce ff15???????? 498bce }
            // n = 7, score = 400
            //   4d85f6               | je                  0x1b04
            //   741a                 | cmp                 esi, dword ptr [edi + 0x14]
            //   33d2                 | ja                  0x1b04
            //   41b880010000         | dec                 eax
            //   498bce               | arpl                si, dx
            //   ff15????????         |                     
            //   498bce               | mov                 ecx, dword ptr [edi + 0x1c]

        $sequence_7 = { 488b7128 4885ff 0f84e1000000 4885f6 0f84d8000000 488d8424c0000000 4889442420 }
            // n = 7, score = 400
            //   488b7128             | dec                 eax
            //   4885ff               | test                ebx, ebx
            //   0f84e1000000         | dec                 esp
            //   4885f6               | mov                 ecx, dword ptr [eax]
            //   0f84d8000000         | or                  ebp, 0xffffffff
            //   488d8424c0000000     | dec                 eax
            //   4889442420           | mov                 edi, ecx

        $sequence_8 = { 81790800000306 7308 418bc6 e9???????? 488d842418010000 4889442420 41b9a0000000 }
            // n = 7, score = 400
            //   81790800000306       | dec                 eax
            //   7308                 | lea                 edx, [esp + 0x20]
            //   418bc6               | dec                 eax
            //   e9????????           |                     
            //   488d842418010000     | lea                 ecx, [esp + 0x20]
            //   4889442420           | mov                 ebx, eax
            //   41b9a0000000         | test                eax, eax

        $sequence_9 = { 897918 488b03 488b8898000000 89791c 488b03 488b8898000000 c7413809000000 }
            // n = 7, score = 400
            //   897918               | mov                 edi, 0x80010705
            //   488b03               | dec                 eax
            //   488b8898000000       | mov                 ebx, eax
            //   89791c               | dec                 eax
            //   488b03               | cmp                 eax, -1
            //   488b8898000000       | je                  0x1320
            //   c7413809000000       | mov                 dword ptr [eax - 0x28], 3

    condition:
        7 of them and filesize < 589824
}