rule win_action_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.action_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.action_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b10 8955ec 8b45ec 3b45f0 7707 e8???????? eb3c }
            // n = 7, score = 100
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   3b45f0               | cmp                 eax, dword ptr [ebp - 0x10]
            //   7707                 | ja                  9
            //   e8????????           |                     
            //   eb3c                 | jmp                 0x3e

        $sequence_1 = { 894d9c c645fc00 8d4db0 e8???????? c745fcffffffff 8d4d18 e8???????? }
            // n = 7, score = 100
            //   894d9c               | mov                 dword ptr [ebp - 0x64], ecx
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4d18               | lea                 ecx, [ebp + 0x18]
            //   e8????????           |                     

        $sequence_2 = { 8b4df8 c1e104 81c1???????? e8???????? 8b55f8 c1e204 038298f80210 }
            // n = 7, score = 100
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   c1e104               | shl                 ecx, 4
            //   81c1????????         |                     
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   c1e204               | shl                 edx, 4
            //   038298f80210         | add                 eax, dword ptr [edx + 0x1002f898]

        $sequence_3 = { 51 ff15???????? 83c404 85c0 7412 0fbe5508 83ea30 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7412                 | je                  0x14
            //   0fbe5508             | movsx               edx, byte ptr [ebp + 8]
            //   83ea30               | sub                 edx, 0x30

        $sequence_4 = { 8b55f4 837a1800 7420 0fb645fb 50 8b4df4 8b4918 }
            // n = 7, score = 100
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   837a1800             | cmp                 dword ptr [edx + 0x18], 0
            //   7420                 | je                  0x22
            //   0fb645fb             | movzx               eax, byte ptr [ebp - 5]
            //   50                   | push                eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b4918               | mov                 ecx, dword ptr [ecx + 0x18]

        $sequence_5 = { e8???????? 83c408 8d450c 50 8b4dec 83c104 51 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   83c104               | add                 ecx, 4
            //   51                   | push                ecx

        $sequence_6 = { d1e8 8945ec 8b4dec 034dc8 894de0 8b55f8 }
            // n = 6, score = 100
            //   d1e8                 | shr                 eax, 1
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   034dc8               | add                 ecx, dword ptr [ebp - 0x38]
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_7 = { 8d4dec 51 8b4d08 e8???????? 50 8d55d0 }
            // n = 6, score = 100
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   51                   | push                ecx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d55d0               | lea                 edx, [ebp - 0x30]

        $sequence_8 = { 7702 eb02 eb9f 6a00 8b4dd4 51 8d4dd8 }
            // n = 7, score = 100
            //   7702                 | ja                  4
            //   eb02                 | jmp                 4
            //   eb9f                 | jmp                 0xffffffa1
            //   6a00                 | push                0
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]

        $sequence_9 = { 8d4dd8 e8???????? 50 e8???????? 83c414 8945d4 8d4dd8 }
            // n = 7, score = 100
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]

    condition:
        7 of them and filesize < 480256
}