rule win_adylkuzz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.adylkuzz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.adylkuzz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1c002 3bec f5 33d8 03f8 e9???????? 668b442500 }
            // n = 7, score = 100
            //   c1c002               | rol                 eax, 2
            //   3bec                 | cmp                 ebp, esp
            //   f5                   | cmc                 
            //   33d8                 | xor                 ebx, eax
            //   03f8                 | add                 edi, eax
            //   e9????????           |                     
            //   668b442500           | mov                 ax, word ptr [ebp]

        $sequence_1 = { e8???????? 8b35???????? b9???????? 89d8 8b7b08 89f2 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b35????????         |                     
            //   b9????????           |                     
            //   89d8                 | mov                 eax, ebx
            //   8b7b08               | mov                 edi, dword ptr [ebx + 8]
            //   89f2                 | mov                 edx, esi
            //   e8????????           |                     

        $sequence_2 = { f8 81c508000000 f5 f9 8901 660fc1c0 81ee04000000 }
            // n = 7, score = 100
            //   f8                   | clc                 
            //   81c508000000         | add                 ebp, 8
            //   f5                   | cmc                 
            //   f9                   | stc                 
            //   8901                 | mov                 dword ptr [ecx], eax
            //   660fc1c0             | xadd                ax, ax
            //   81ee04000000         | sub                 esi, 4

        $sequence_3 = { f6c32d 3bce d2e8 6689442504 0fbfc2 660fb6c5 0fc8 }
            // n = 7, score = 100
            //   f6c32d               | test                bl, 0x2d
            //   3bce                 | cmp                 ecx, esi
            //   d2e8                 | shr                 al, cl
            //   6689442504           | mov                 word ptr [ebp + 4], ax
            //   0fbfc2               | movsx               eax, dx
            //   660fb6c5             | movzx               ax, ch
            //   0fc8                 | bswap               eax

        $sequence_4 = { f7d8 33d8 663bd2 f5 03f8 ffe7 660fb6442500 }
            // n = 7, score = 100
            //   f7d8                 | neg                 eax
            //   33d8                 | xor                 ebx, eax
            //   663bd2               | cmp                 dx, dx
            //   f5                   | cmc                 
            //   03f8                 | add                 edi, eax
            //   ffe7                 | jmp                 edi
            //   660fb6442500         | movzx               ax, byte ptr [ebp]

        $sequence_5 = { c7042400000000 b90b000000 89fa 89d8 e8???????? 85c0 7482 }
            // n = 7, score = 100
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   b90b000000           | mov                 ecx, 0xb
            //   89fa                 | mov                 edx, edi
            //   89d8                 | mov                 eax, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7482                 | je                  0xffffff84

        $sequence_6 = { df6c2428 eb77 837c241c08 0f8595020000 f744242000008000 7504 df2e }
            // n = 7, score = 100
            //   df6c2428             | fild                qword ptr [esp + 0x28]
            //   eb77                 | jmp                 0x79
            //   837c241c08           | cmp                 dword ptr [esp + 0x1c], 8
            //   0f8595020000         | jne                 0x29b
            //   f744242000008000     | test                dword ptr [esp + 0x20], 0x800000
            //   7504                 | jne                 6
            //   df2e                 | fild                qword ptr [esi]

        $sequence_7 = { f7d0 8b06 f5 6685fb 33c3 f9 663bf0 }
            // n = 7, score = 100
            //   f7d0                 | not                 eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   f5                   | cmc                 
            //   6685fb               | test                bx, di
            //   33c3                 | xor                 eax, ebx
            //   f9                   | stc                 
            //   663bf0               | cmp                 si, ax

        $sequence_8 = { 8b5034 39d1 0f47ca f6c740 7408 8b5038 39d1 }
            // n = 7, score = 100
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   39d1                 | cmp                 ecx, edx
            //   0f47ca               | cmova               ecx, edx
            //   f6c740               | test                bh, 0x40
            //   7408                 | je                  0xa
            //   8b5038               | mov                 edx, dword ptr [eax + 0x38]
            //   39d1                 | cmp                 ecx, edx

        $sequence_9 = { e8???????? 8b5e08 83fb03 7518 8b16 b9fbffffff 89e8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b5e08               | mov                 ebx, dword ptr [esi + 8]
            //   83fb03               | cmp                 ebx, 3
            //   7518                 | jne                 0x1a
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   b9fbffffff           | mov                 ecx, 0xfffffffb
            //   89e8                 | mov                 eax, ebp

    condition:
        7 of them and filesize < 6438912
}