rule win_agfspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.agfspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.agfspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8901 8b0b 85c9 7405 8b01 ff5010 8933 }
            // n = 7, score = 400
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   85c9                 | test                ecx, ecx
            //   7405                 | je                  7
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   8933                 | mov                 dword ptr [ebx], esi

        $sequence_1 = { 8bc6 8b4d0c 890e 8b4d10 5f 894e04 5e }
            // n = 7, score = 400
            //   8bc6                 | mov                 eax, esi
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   890e                 | mov                 dword ptr [esi], ecx
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   5f                   | pop                 edi
            //   894e04               | mov                 dword ptr [esi + 4], ecx
            //   5e                   | pop                 esi

        $sequence_2 = { c744c81000000000 8d2cc8 8b4c241c c7451400000000 0f1001 0f114500 f30f7e4110 }
            // n = 7, score = 400
            //   c744c81000000000     | mov                 dword ptr [eax + ecx*8 + 0x10], 0
            //   8d2cc8               | lea                 ebp, [eax + ecx*8]
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   c7451400000000       | mov                 dword ptr [ebp + 0x14], 0
            //   0f1001               | movups              xmm0, xmmword ptr [ecx]
            //   0f114500             | movups              xmmword ptr [ebp], xmm0
            //   f30f7e4110           | movq                xmm0, qword ptr [ecx + 0x10]

        $sequence_3 = { 8bc8 6a01 ff12 8d4d98 e8???????? 0f57c0 c745e800000000 }
            // n = 7, score = 400
            //   8bc8                 | mov                 ecx, eax
            //   6a01                 | push                1
            //   ff12                 | call                dword ptr [edx]
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   e8????????           |                     
            //   0f57c0               | xorps               xmm0, xmm0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0

        $sequence_4 = { b801000000 eb40 83ec08 c6462401 50 e8???????? 8945d0 }
            // n = 7, score = 400
            //   b801000000           | mov                 eax, 1
            //   eb40                 | jmp                 0x42
            //   83ec08               | sub                 esp, 8
            //   c6462401             | mov                 byte ptr [esi + 0x24], 1
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax

        $sequence_5 = { 5e 5b 8be5 5d c20400 8b470c 33f6 }
            // n = 7, score = 400
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   33f6                 | xor                 esi, esi

        $sequence_6 = { 3c0a 7409 6a0a 8bce e8???????? 837f3c10 8d4728 }
            // n = 7, score = 400
            //   3c0a                 | cmp                 al, 0xa
            //   7409                 | je                  0xb
            //   6a0a                 | push                0xa
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   837f3c10             | cmp                 dword ptr [edi + 0x3c], 0x10
            //   8d4728               | lea                 eax, [edi + 0x28]

        $sequence_7 = { b001 c6460401 e9???????? 8b01 ff5018 83f8ff 7405 }
            // n = 7, score = 400
            //   b001                 | mov                 al, 1
            //   c6460401             | mov                 byte ptr [esi + 4], 1
            //   e9????????           |                     
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5018               | call                dword ptr [eax + 0x18]
            //   83f8ff               | cmp                 eax, -1
            //   7405                 | je                  7

        $sequence_8 = { e8???????? 0fb7ff eb16 0fb77c2410 8d4c2414 e8???????? 0fb7ff }
            // n = 7, score = 400
            //   e8????????           |                     
            //   0fb7ff               | movzx               edi, di
            //   eb16                 | jmp                 0x18
            //   0fb77c2410           | movzx               edi, word ptr [esp + 0x10]
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   e8????????           |                     
            //   0fb7ff               | movzx               edi, di

        $sequence_9 = { 8bcf e8???????? 8bc8 e8???????? 8bc8 e8???????? 83ec18 }
            // n = 7, score = 400
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18

    condition:
        7 of them and filesize < 1482752
}