rule win_ahtapot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ahtapot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ahtapot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1fa05 8bc2 c1e81f 03d0 b814000000 2bc2 0fb7542410 }
            // n = 7, score = 100
            //   c1fa05               | sar                 edx, 5
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03d0                 | add                 edx, eax
            //   b814000000           | mov                 eax, 0x14
            //   2bc2                 | sub                 eax, edx
            //   0fb7542410           | movzx               edx, word ptr [esp + 0x10]

        $sequence_1 = { 51 8d9580fbffff 52 8d8570f7ffff 68???????? 50 ffd7 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8d9580fbffff         | lea                 edx, [ebp - 0x480]
            //   52                   | push                edx
            //   8d8570f7ffff         | lea                 eax, [ebp - 0x890]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_2 = { 8d842494000000 6683383f 7508 ba20000000 668910 41 66399c4c94000000 }
            // n = 7, score = 100
            //   8d842494000000       | lea                 eax, [esp + 0x94]
            //   6683383f             | cmp                 word ptr [eax], 0x3f
            //   7508                 | jne                 0xa
            //   ba20000000           | mov                 edx, 0x20
            //   668910               | mov                 word ptr [eax], dx
            //   41                   | inc                 ecx
            //   66399c4c94000000     | cmp                 word ptr [esp + ecx*2 + 0x94], bx

        $sequence_3 = { bf00000800 7413 893d???????? 833b02 7422 }
            // n = 5, score = 100
            //   bf00000800           | mov                 edi, 0x80000
            //   7413                 | je                  0x15
            //   893d????????         |                     
            //   833b02               | cmp                 dword ptr [ebx], 2
            //   7422                 | je                  0x24

        $sequence_4 = { 69c9e8030000 51 ff15???????? 80bec412000000 0f8504fbffff 33c0 8b8c24d8120000 }
            // n = 7, score = 100
            //   69c9e8030000         | imul                ecx, ecx, 0x3e8
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   80bec412000000       | cmp                 byte ptr [esi + 0x12c4], 0
            //   0f8504fbffff         | jne                 0xfffffb0a
            //   33c0                 | xor                 eax, eax
            //   8b8c24d8120000       | mov                 ecx, dword ptr [esp + 0x12d8]

        $sequence_5 = { 7cb7 3d00010000 740a c786a4af060028a74200 8a55fc 8894303c1b0000 8d8eb41e0000 }
            // n = 7, score = 100
            //   7cb7                 | jl                  0xffffffb9
            //   3d00010000           | cmp                 eax, 0x100
            //   740a                 | je                  0xc
            //   c786a4af060028a74200     | mov    dword ptr [esi + 0x6afa4], 0x42a728
            //   8a55fc               | mov                 dl, byte ptr [ebp - 4]
            //   8894303c1b0000       | mov                 byte ptr [eax + esi + 0x1b3c], dl
            //   8d8eb41e0000         | lea                 ecx, [esi + 0x1eb4]

        $sequence_6 = { 0f8494000000 8d85bcf7ffff 8d5002 8d642400 668b08 83c002 6685c9 }
            // n = 7, score = 100
            //   0f8494000000         | je                  0x9a
            //   8d85bcf7ffff         | lea                 eax, [ebp - 0x844]
            //   8d5002               | lea                 edx, [eax + 2]
            //   8d642400             | lea                 esp, [esp]
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx

        $sequence_7 = { 889d65cbffff 89954ccbffff 898550cbffff 899d28cbffff 899d38cbffff 899d48cbffff }
            // n = 6, score = 100
            //   889d65cbffff         | mov                 byte ptr [ebp - 0x349b], bl
            //   89954ccbffff         | mov                 dword ptr [ebp - 0x34b4], edx
            //   898550cbffff         | mov                 dword ptr [ebp - 0x34b0], eax
            //   899d28cbffff         | mov                 dword ptr [ebp - 0x34d8], ebx
            //   899d38cbffff         | mov                 dword ptr [ebp - 0x34c8], ebx
            //   899d48cbffff         | mov                 dword ptr [ebp - 0x34b8], ebx

        $sequence_8 = { 75df 8d85d0fdffff 50 ffd3 8b4dfc 5f 5e }
            // n = 7, score = 100
            //   75df                 | jne                 0xffffffe1
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { 899d70cbffff 899568cbffff 899d60cbffff 3bf3 7533 8b8518cbffff 8b4804 }
            // n = 7, score = 100
            //   899d70cbffff         | mov                 dword ptr [ebp - 0x3490], ebx
            //   899568cbffff         | mov                 dword ptr [ebp - 0x3498], edx
            //   899d60cbffff         | mov                 dword ptr [ebp - 0x34a0], ebx
            //   3bf3                 | cmp                 esi, ebx
            //   7533                 | jne                 0x35
            //   8b8518cbffff         | mov                 eax, dword ptr [ebp - 0x34e8]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]

    condition:
        7 of them and filesize < 430080
}