rule win_albaniiutas_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.albaniiutas."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.albaniiutas"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745e410000000 c705????????02000000 c745e802000000 c745ec07000000 c745f000000000 }
            // n = 5, score = 100
            //   c745e410000000       | mov                 dword ptr [ebp - 0x1c], 0x10
            //   c705????????02000000     |     
            //   c745e802000000       | mov                 dword ptr [ebp - 0x18], 2
            //   c745ec07000000       | mov                 dword ptr [ebp - 0x14], 7
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0

        $sequence_1 = { 03048d90df0210 50 ff15???????? 5d }
            // n = 4, score = 100
            //   03048d90df0210       | add                 eax, dword ptr [ecx*4 + 0x1002df90]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5d                   | pop                 ebp

        $sequence_2 = { 83c40c 5d c20c00 e9???????? 55 8bec ff7508 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_3 = { 56 8b048d90df0210 57 8b7d10 }
            // n = 4, score = 100
            //   56                   | push                esi
            //   8b048d90df0210       | mov                 eax, dword ptr [ecx*4 + 0x1002df90]
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]

        $sequence_4 = { 8b049590df0210 f644082801 7421 57 e8???????? 59 50 }
            // n = 7, score = 100
            //   8b049590df0210       | mov                 eax, dword ptr [edx*4 + 0x1002df90]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7421                 | je                  0x23
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax

        $sequence_5 = { 8975ec 0fb70445b01a0110 66894c4774 8bcf }
            // n = 4, score = 100
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   0fb70445b01a0110     | movzx               eax, word ptr [eax*2 + 0x10011ab0]
            //   66894c4774           | mov                 word ptr [edi + eax*2 + 0x74], cx
            //   8bcf                 | mov                 ecx, edi

        $sequence_6 = { 0f8e6fffffff 83c8ff eb07 8b04cd4c6b0110 }
            // n = 4, score = 100
            //   0f8e6fffffff         | jle                 0xffffff75
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb07                 | jmp                 9
            //   8b04cd4c6b0110       | mov                 eax, dword ptr [ecx*8 + 0x10016b4c]

        $sequence_7 = { 8b4508 c740183c1b0110 c74104513f0000 e9???????? }
            // n = 4, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c740183c1b0110       | mov                 dword ptr [eax + 0x18], 0x10011b3c
            //   c74104513f0000       | mov                 dword ptr [ecx + 4], 0x3f51
            //   e9????????           |                     

        $sequence_8 = { 8b4508 c74018241c0110 e9???????? 8b550c c74104473f0000 83fa06 0f8430070000 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c74018241c0110       | mov                 dword ptr [eax + 0x18], 0x10011c24
            //   e9????????           |                     
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   c74104473f0000       | mov                 dword ptr [ecx + 4], 0x3f47
            //   83fa06               | cmp                 edx, 6
            //   0f8430070000         | je                  0x736

        $sequence_9 = { c74048c0a40110 8b4508 6689486c 8b4508 }
            // n = 4, score = 100
            //   c74048c0a40110       | mov                 dword ptr [eax + 0x48], 0x1001a4c0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   6689486c             | mov                 word ptr [eax + 0x6c], cx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 566272
}