rule win_alice_atm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alice_atm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alice_atm"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 682e010000 ff7110 e8???????? 8bd8 }
            // n = 4, score = 200
            //   682e010000           | push                0x12e
            //   ff7110               | push                dword ptr [ecx + 0x10]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_1 = { 0bc0 0f841b010000 b910000000 33d2 f7f1 0fb7f8 }
            // n = 6, score = 200
            //   0bc0                 | or                  eax, eax
            //   0f841b010000         | je                  0x121
            //   b910000000           | mov                 ecx, 0x10
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx
            //   0fb7f8               | movzx               edi, ax

        $sequence_2 = { 0f85b7000000 e8???????? ff7508 8f05???????? 68ea030000 }
            // n = 5, score = 200
            //   0f85b7000000         | jne                 0xbd
            //   e8????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8f05????????         |                     
            //   68ea030000           | push                0x3ea

        $sequence_3 = { 53 e8???????? e9???????? 817d0c11010000 0f858b000000 8b4d10 6681f9d507 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   e8????????           |                     
            //   e9????????           |                     
            //   817d0c11010000       | cmp                 dword ptr [ebp + 0xc], 0x111
            //   0f858b000000         | jne                 0x91
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   6681f9d507           | cmp                 cx, 0x7d5

        $sequence_4 = { 7434 8d75d4 6a28 56 }
            // n = 4, score = 200
            //   7434                 | je                  0x36
            //   8d75d4               | lea                 esi, [ebp - 0x2c]
            //   6a28                 | push                0x28
            //   56                   | push                esi

        $sequence_5 = { 68ec030000 ff7508 e8???????? 8bf0 }
            // n = 4, score = 200
            //   68ec030000           | push                0x3ec
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { 55 8bec 81c4f4fdffff 53 56 57 33ff }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c4f4fdffff         | add                 esp, 0xfffffdf4
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi

        $sequence_7 = { 33c0 8945fc 8b5d08 0bdb 7414 6a00 6a00 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   0bdb                 | or                  ebx, ebx
            //   7414                 | je                  0x16
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 6a00 68e8030000 ff35???????? e8???????? }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   68e8030000           | push                0x3e8
            //   ff35????????         |                     
            //   e8????????           |                     

        $sequence_9 = { f7f1 0fb7c0 8945f8 8b7d10 83ff00 0f86c2000000 3b7df8 }
            // n = 7, score = 200
            //   f7f1                 | div                 ecx
            //   0fb7c0               | movzx               eax, ax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   83ff00               | cmp                 edi, 0
            //   0f86c2000000         | jbe                 0xc8
            //   3b7df8               | cmp                 edi, dword ptr [ebp - 8]

    condition:
        7 of them and filesize < 49152
}