rule win_alina_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alina_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alina_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7439 6828010000 8d85d0feffff 6a00 50 e8???????? 83c40c }
            // n = 7, score = 2400
            //   7439                 | je                  0x3b
            //   6828010000           | push                0x128
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_1 = { 3bc1 7763 83ceff 3bc8 }
            // n = 4, score = 2000
            //   3bc1                 | cmp                 eax, ecx
            //   7763                 | ja                  0x65
            //   83ceff               | or                  esi, 0xffffffff
            //   3bc8                 | cmp                 ecx, eax

        $sequence_2 = { 8bd7 2bce 2bc8 51 03fe }
            // n = 5, score = 2000
            //   8bd7                 | mov                 edx, edi
            //   2bce                 | sub                 ecx, esi
            //   2bc8                 | sub                 ecx, eax
            //   51                   | push                ecx
            //   03fe                 | add                 edi, esi

        $sequence_3 = { 3975e8 720c 8b45d4 50 e8???????? 83c404 32c0 }
            // n = 7, score = 2000
            //   3975e8               | cmp                 dword ptr [ebp - 0x18], esi
            //   720c                 | jb                  0xe
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   32c0                 | xor                 al, al

        $sequence_4 = { 39410c 7305 8b4908 eb04 8bd1 }
            // n = 5, score = 2000
            //   39410c               | cmp                 dword ptr [ecx + 0xc], eax
            //   7305                 | jae                 7
            //   8b4908               | mov                 ecx, dword ptr [ecx + 8]
            //   eb04                 | jmp                 6
            //   8bd1                 | mov                 edx, ecx

        $sequence_5 = { 03fe 03f8 03d0 57 }
            // n = 4, score = 2000
            //   03fe                 | add                 edi, esi
            //   03f8                 | add                 edi, eax
            //   03d0                 | add                 edx, eax
            //   57                   | push                edi

        $sequence_6 = { 83faff 7306 8bf2 85f6 }
            // n = 4, score = 2000
            //   83faff               | cmp                 edx, -1
            //   7306                 | jae                 8
            //   8bf2                 | mov                 esi, edx
            //   85f6                 | test                esi, esi

        $sequence_7 = { 85c0 75cd 56 e8???????? }
            // n = 4, score = 2000
            //   85c0                 | test                eax, eax
            //   75cd                 | jne                 0xffffffcf
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_8 = { 8b4314 8a0a 884d10 85c0 741c }
            // n = 5, score = 1800
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   884d10               | mov                 byte ptr [ebp + 0x10], cl
            //   85c0                 | test                eax, eax
            //   741c                 | je                  0x1e

        $sequence_9 = { 6800000080 50 ff15???????? 85c0 }
            // n = 4, score = 1600
            //   6800000080           | push                0x80000000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_10 = { 8d85f0feffff 50 6805010000 ff15???????? }
            // n = 4, score = 1600
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   6805010000           | push                0x105
            //   ff15????????         |                     

        $sequence_11 = { 7406 c70100000000 6a00 6a00 }
            // n = 4, score = 1400
            //   7406                 | je                  8
            //   c70100000000         | mov                 dword ptr [ecx], 0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_12 = { 8bf0 8d45ec 50 6800040000 }
            // n = 4, score = 1400
            //   8bf0                 | mov                 esi, eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   6800040000           | push                0x400

        $sequence_13 = { ff15???????? 50 6a73 68???????? }
            // n = 4, score = 1400
            //   ff15????????         |                     
            //   50                   | push                eax
            //   6a73                 | push                0x73
            //   68????????           |                     

        $sequence_14 = { 8b45ec 85c0 7464 03f8 }
            // n = 4, score = 1400
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   85c0                 | test                eax, eax
            //   7464                 | je                  0x66
            //   03f8                 | add                 edi, eax

        $sequence_15 = { ff15???????? 50 6a70 68???????? }
            // n = 4, score = 1400
            //   ff15????????         |                     
            //   50                   | push                eax
            //   6a70                 | push                0x70
            //   68????????           |                     

        $sequence_16 = { 6a13 53 c645f000 c745d00a000000 }
            // n = 4, score = 1400
            //   6a13                 | push                0x13
            //   53                   | push                ebx
            //   c645f000             | mov                 byte ptr [ebp - 0x10], 0
            //   c745d00a000000       | mov                 dword ptr [ebp - 0x30], 0xa

        $sequence_17 = { ff15???????? 85c0 0f95c0 eb02 b001 }
            // n = 5, score = 1300
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f95c0               | setne               al
            //   eb02                 | jmp                 4
            //   b001                 | mov                 al, 1

        $sequence_18 = { 6810270000 ff15???????? 6a00 6a0f }
            // n = 4, score = 1200
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a0f                 | push                0xf

        $sequence_19 = { ff15???????? 50 6a5f 68???????? }
            // n = 4, score = 1200
            //   ff15????????         |                     
            //   50                   | push                eax
            //   6a5f                 | push                0x5f
            //   68????????           |                     

        $sequence_20 = { 64a300000000 6800100000 e8???????? 8b5d08 }
            // n = 4, score = 1200
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   6800100000           | push                0x1000
            //   e8????????           |                     
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_21 = { ffd3 85c0 7405 83f8ff 7513 68b0040000 ff15???????? }
            // n = 7, score = 1000
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   83f8ff               | cmp                 eax, -1
            //   7513                 | jne                 0x15
            //   68b0040000           | push                0x4b0
            //   ff15????????         |                     

        $sequence_22 = { 8d4720 50 ff15???????? 8b4718 }
            // n = 4, score = 1000
            //   8d4720               | lea                 eax, [edi + 0x20]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]

        $sequence_23 = { 6a00 6800000080 6a00 6a00 68???????? 68???????? }
            // n = 6, score = 1000
            //   6a00                 | push                0
            //   6800000080           | push                0x80000000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   68????????           |                     

        $sequence_24 = { 85f6 743e 83feff 7439 }
            // n = 4, score = 800
            //   85f6                 | test                esi, esi
            //   743e                 | je                  0x40
            //   83feff               | cmp                 esi, -1
            //   7439                 | je                  0x3b

        $sequence_25 = { 57 6800040000 52 8d85fcfbffff 50 e8???????? 8b3d???????? }
            // n = 7, score = 800
            //   57                   | push                edi
            //   6800040000           | push                0x400
            //   52                   | push                edx
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b3d????????         |                     

        $sequence_26 = { a801 7409 d1e8 352083b8ed eb02 d1e8 8901 }
            // n = 7, score = 700
            //   a801                 | test                al, 1
            //   7409                 | je                  0xb
            //   d1e8                 | shr                 eax, 1
            //   352083b8ed           | xor                 eax, 0xedb88320
            //   eb02                 | jmp                 4
            //   d1e8                 | shr                 eax, 1
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_27 = { 8b4508 8945dc eb52 8b45dc 33d2 b903000000 }
            // n = 6, score = 600
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   eb52                 | jmp                 0x54
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   33d2                 | xor                 edx, edx
            //   b903000000           | mov                 ecx, 3

        $sequence_28 = { 89852cfeffff 8b8d2cfeffff 898d28feffff c645fc03 }
            // n = 4, score = 600
            //   89852cfeffff         | mov                 dword ptr [ebp - 0x1d4], eax
            //   8b8d2cfeffff         | mov                 ecx, dword ptr [ebp - 0x1d4]
            //   898d28feffff         | mov                 dword ptr [ebp - 0x1d8], ecx
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3

        $sequence_29 = { 898d28feffff c645fc03 8b9528feffff 52 }
            // n = 4, score = 600
            //   898d28feffff         | mov                 dword ptr [ebp - 0x1d8], ecx
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8b9528feffff         | mov                 edx, dword ptr [ebp - 0x1d8]
            //   52                   | push                edx

        $sequence_30 = { 8b4814 51 6a00 8b4df8 e8???????? }
            // n = 5, score = 600
            //   8b4814               | push                1
            //   51                   | push                0x80000000
            //   6a00                 | push                eax
            //   8b4df8               | test                eax, eax
            //   e8????????           |                     

        $sequence_31 = { 8b45e8 8b4ddc 894818 8b450c 50 8b4de8 e8???????? }
            // n = 7, score = 600
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   894818               | mov                 dword ptr [eax + 0x18], ecx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e8????????           |                     

        $sequence_32 = { 8b45dc 33d2 b903000000 f7f1 8b55e8 8b4a18 d1e9 }
            // n = 7, score = 600
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   33d2                 | xor                 edx, edx
            //   b903000000           | mov                 ecx, 3
            //   f7f1                 | div                 ecx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b4a18               | mov                 ecx, dword ptr [edx + 0x18]
            //   d1e9                 | shr                 ecx, 1

        $sequence_33 = { 8b45e8 8b7018 d1ee 8b4de8 }
            // n = 4, score = 600
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b7018               | mov                 esi, dword ptr [eax + 0x18]
            //   d1ee                 | shr                 esi, 1
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]

        $sequence_34 = { 8b45e8 8b4818 d1e9 8b55e8 034a18 894ddc eb0b }
            // n = 7, score = 600
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b4818               | mov                 ecx, dword ptr [eax + 0x18]
            //   d1e9                 | shr                 ecx, 1
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   034a18               | add                 ecx, dword ptr [edx + 0x18]
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   eb0b                 | jmp                 0xd

        $sequence_35 = { e8???????? 4885c0 7509 488d053fae0100 eb04 4883c024 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4885c0               | dec                 esp
            //   7509                 | mov                 eax, ebx
            //   488d053fae0100       | mov                 dword ptr [esp + 0x28], eax
            //   eb04                 | inc                 ebp
            //   4883c024             | xor                 eax, eax

        $sequence_36 = { e8???????? 488bd7 4c8d052a8a0100 83e23f 488bcf 48c1f906 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488bd7               | dec                 eax
            //   4c8d052a8a0100       | mov                 edx, edi
            //   83e23f               | dec                 esp
            //   488bcf               | lea                 eax, [0x18a2a]
            //   48c1f906             | and                 edx, 0x3f

        $sequence_37 = { 89442428 4533c0 48896c2420 ff15???????? 48ffc3 803c1f00 }
            // n = 6, score = 100
            //   89442428             | mov                 eax, dword ptr [ebx]
            //   4533c0               | jmp                 5
            //   48896c2420           | dec                 eax
            //   ff15????????         |                     
            //   48ffc3               | mov                 eax, ebx
            //   803c1f00             | dec                 eax

        $sequence_38 = { 488b03 eb03 488bc3 482bf0 4c894c2420 4c8bce 4c8bc3 }
            // n = 7, score = 100
            //   488b03               | js                  0x34
            //   eb03                 | jae                 0x2e
            //   488bc3               | dec                 eax
            //   482bf0               | arpl                cx, dx
            //   4c894c2420           | dec                 eax
            //   4c8bce               | lea                 ecx, [0x15d98]
            //   4c8bc3               | dec                 eax

        $sequence_39 = { 742b b904000000 e8???????? 90 488bd7 488d0dd9cc0100 }
            // n = 6, score = 100
            //   742b                 | sub                 esi, eax
            //   b904000000           | dec                 esp
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [esp + 0x20], ecx
            //   488bd7               | dec                 esp
            //   488d0dd9cc0100       | mov                 ecx, esi

        $sequence_40 = { 85c9 7832 3b0d???????? 732a 4863d1 488d0d985d0100 }
            // n = 6, score = 100
            //   85c9                 | dec                 eax
            //   7832                 | mov                 ecx, edi
            //   3b0d????????         |                     
            //   732a                 | dec                 eax
            //   4863d1               | sar                 ecx, 6
            //   488d0d985d0100       | test                ecx, ecx

    condition:
        7 of them and filesize < 2498560
}