rule win_alma_communicator_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alma_communicator."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alma_communicator"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e13f 6bc930 53 8b5d10 8b0485f08f4100 56 8b7508 }
            // n = 7, score = 200
            //   83e13f               | and                 ecx, 0x3f
            //   6bc930               | imul                ecx, ecx, 0x30
            //   53                   | push                ebx
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   8b0485f08f4100       | mov                 eax, dword ptr [eax*4 + 0x418ff0]
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_1 = { 88040a 41 84c0 75f6 ba???????? }
            // n = 5, score = 200
            //   88040a               | mov                 byte ptr [edx + ecx], al
            //   41                   | inc                 ecx
            //   84c0                 | test                al, al
            //   75f6                 | jne                 0xfffffff8
            //   ba????????           |                     

        $sequence_2 = { 68f4010000 e8???????? 8364242800 8bf0 59 }
            // n = 5, score = 200
            //   68f4010000           | push                0x1f4
            //   e8????????           |                     
            //   8364242800           | and                 dword ptr [esp + 0x28], 0
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx

        $sequence_3 = { 8b0485f08f4100 56 8b7508 57 }
            // n = 4, score = 200
            //   8b0485f08f4100       | mov                 eax, dword ptr [eax*4 + 0x418ff0]
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_4 = { 8a4f01 47 84c9 75f8 8d8de0fdffff 668907 e8???????? }
            // n = 7, score = 200
            //   8a4f01               | mov                 cl, byte ptr [edi + 1]
            //   47                   | inc                 edi
            //   84c9                 | test                cl, cl
            //   75f8                 | jne                 0xfffffffa
            //   8d8de0fdffff         | lea                 ecx, [ebp - 0x220]
            //   668907               | mov                 word ptr [edi], ax
            //   e8????????           |                     

        $sequence_5 = { eb06 8b9d18ddffff 57 e8???????? }
            // n = 4, score = 200
            //   eb06                 | jmp                 8
            //   8b9d18ddffff         | mov                 ebx, dword ptr [ebp - 0x22e8]
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_6 = { 52 52 ff15???????? 89849da0e9ffff 43 68e8030000 }
            // n = 6, score = 200
            //   52                   | push                edx
            //   52                   | push                edx
            //   ff15????????         |                     
            //   89849da0e9ffff       | mov                 dword ptr [ebp + ebx*4 - 0x1660], eax
            //   43                   | inc                 ebx
            //   68e8030000           | push                0x3e8

        $sequence_7 = { 0f4ecb 8bd9 7fe6 8bfe 8d4f01 }
            // n = 5, score = 200
            //   0f4ecb               | cmovle              ecx, ebx
            //   8bd9                 | mov                 ebx, ecx
            //   7fe6                 | jg                  0xffffffe8
            //   8bfe                 | mov                 edi, esi
            //   8d4f01               | lea                 ecx, [edi + 1]

        $sequence_8 = { 59 33c9 89442414 8bf1 }
            // n = 4, score = 200
            //   59                   | pop                 ecx
            //   33c9                 | xor                 ecx, ecx
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8bf1                 | mov                 esi, ecx

        $sequence_9 = { 59 59 8945f4 8d45f8 50 }
            // n = 5, score = 200
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 245760
}