rule win_alma_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alma_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alma_locker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750d e8???????? 84c0 0f8461010000 e8???????? 833d????????00 }
            // n = 6, score = 100
            //   750d                 | jne                 0xf
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f8461010000         | je                  0x167
            //   e8????????           |                     
            //   833d????????00       |                     

        $sequence_1 = { 8b08 ff5108 8b45ac 50 8b08 ff5108 }
            // n = 6, score = 100
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b45ac               | mov                 eax, dword ptr [ebp - 0x54]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]

        $sequence_2 = { c745e800000000 c645d800 720b ff75c0 e8???????? 83c404 83ec18 }
            // n = 7, score = 100
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c645d800             | mov                 byte ptr [ebp - 0x28], 0
            //   720b                 | jb                  0xd
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83ec18               | sub                 esp, 0x18

        $sequence_3 = { 8b85f8fbffff 0f438de8fbffff ffb538f9ffff c785e4fbffff0f000000 c785e0fbffff00000000 8d0441 c685d0fbffff00 }
            // n = 7, score = 100
            //   8b85f8fbffff         | mov                 eax, dword ptr [ebp - 0x408]
            //   0f438de8fbffff       | cmovae              ecx, dword ptr [ebp - 0x418]
            //   ffb538f9ffff         | push                dword ptr [ebp - 0x6c8]
            //   c785e4fbffff0f000000     | mov    dword ptr [ebp - 0x41c], 0xf
            //   c785e0fbffff00000000     | mov    dword ptr [ebp - 0x420], 0
            //   8d0441               | lea                 eax, [ecx + eax*2]
            //   c685d0fbffff00       | mov                 byte ptr [ebp - 0x430], 0

        $sequence_4 = { 1bc0 f7d8 0f854affffff 8b8580fbffff 51 83c0fe 8d8d70fbffff }
            // n = 7, score = 100
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   0f854affffff         | jne                 0xffffff50
            //   8b8580fbffff         | mov                 eax, dword ptr [ebp - 0x480]
            //   51                   | push                ecx
            //   83c0fe               | add                 eax, -2
            //   8d8d70fbffff         | lea                 ecx, [ebp - 0x490]

        $sequence_5 = { 8d558c c645fc04 8d4dbc e8???????? 83c404 c645fc06 837db810 }
            // n = 7, score = 100
            //   8d558c               | lea                 edx, [ebp - 0x74]
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   837db810             | cmp                 dword ptr [ebp - 0x48], 0x10

        $sequence_6 = { 33c0 c645fc0d 33c9 66a3???????? 66390d???????? 8bc6 c705????????07000000 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   c645fc0d             | mov                 byte ptr [ebp - 4], 0xd
            //   33c9                 | xor                 ecx, ecx
            //   66a3????????         |                     
            //   66390d????????       |                     
            //   8bc6                 | mov                 eax, esi
            //   c705????????07000000     |     

        $sequence_7 = { 0f8412000000 83a5e0fffefffe 8b8de8fffeff e9???????? c3 8b542408 8d420c }
            // n = 7, score = 100
            //   0f8412000000         | je                  0x18
            //   83a5e0fffefffe       | and                 dword ptr [ebp - 0x10020], 0xfffffffe
            //   8b8de8fffeff         | mov                 ecx, dword ptr [ebp - 0x10018]
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d420c               | lea                 eax, [edx + 0xc]

        $sequence_8 = { c78598fbffff00000000 c7859cfbffff0f000000 720e ffb558fbffff e8???????? 83c404 83bdccfbffff08 }
            // n = 7, score = 100
            //   c78598fbffff00000000     | mov    dword ptr [ebp - 0x468], 0
            //   c7859cfbffff0f000000     | mov    dword ptr [ebp - 0x464], 0xf
            //   720e                 | jb                  0x10
            //   ffb558fbffff         | push                dword ptr [ebp - 0x4a8]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83bdccfbffff08       | cmp                 dword ptr [ebp - 0x434], 8

        $sequence_9 = { 83bd9cfbffff10 c78584fbffff0f000000 c78580fbffff00000000 c68570fbffff00 720e ffb588fbffff }
            // n = 6, score = 100
            //   83bd9cfbffff10       | cmp                 dword ptr [ebp - 0x464], 0x10
            //   c78584fbffff0f000000     | mov    dword ptr [ebp - 0x47c], 0xf
            //   c78580fbffff00000000     | mov    dword ptr [ebp - 0x480], 0
            //   c68570fbffff00       | mov                 byte ptr [ebp - 0x490], 0
            //   720e                 | jb                  0x10
            //   ffb588fbffff         | push                dword ptr [ebp - 0x478]

    condition:
        7 of them and filesize < 335872
}