rule win_alphanc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alphanc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alphanc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8d45f0 8d4de8 50 51 ff15???????? 57 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_1 = { 8d044544ce4e00 eb59 8d044542ce4e00 eb50 f6c303 740d 0fb74208 }
            // n = 7, score = 100
            //   8d044544ce4e00       | lea                 eax, [eax*2 + 0x4ece44]
            //   eb59                 | jmp                 0x5b
            //   8d044542ce4e00       | lea                 eax, [eax*2 + 0x4ece42]
            //   eb50                 | jmp                 0x52
            //   f6c303               | test                bl, 3
            //   740d                 | je                  0xf
            //   0fb74208             | movzx               eax, word ptr [edx + 8]

        $sequence_2 = { 8b6c2424 55 56 e8???????? 8b542458 83c408 8d4aff }
            // n = 7, score = 100
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   55                   | push                ebp
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b542458             | mov                 edx, dword ptr [esp + 0x58]
            //   83c408               | add                 esp, 8
            //   8d4aff               | lea                 ecx, [edx - 1]

        $sequence_3 = { bf50000000 6a41 e9???????? 56 e8???????? 83c404 85c0 }
            // n = 7, score = 100
            //   bf50000000           | mov                 edi, 0x50
            //   6a41                 | push                0x41
            //   e9????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_4 = { e8???????? 85c0 7526 8a4b7c 8a142e 32d1 6857a0a6f8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7526                 | jne                 0x28
            //   8a4b7c               | mov                 cl, byte ptr [ebx + 0x7c]
            //   8a142e               | mov                 dl, byte ptr [esi + ebp]
            //   32d1                 | xor                 dl, cl
            //   6857a0a6f8           | push                0xf8a6a057

        $sequence_5 = { 8b6c2438 68f1000000 68???????? 6a68 6891000000 6a04 e8???????? }
            // n = 7, score = 100
            //   8b6c2438             | mov                 ebp, dword ptr [esp + 0x38]
            //   68f1000000           | push                0xf1
            //   68????????           |                     
            //   6a68                 | push                0x68
            //   6891000000           | push                0x91
            //   6a04                 | push                4
            //   e8????????           |                     

        $sequence_6 = { 8b7c240c 8b4604 894704 8b0e 8b5608 51 52 }
            // n = 7, score = 100
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_7 = { e8???????? 8be8 83c40c 85ed 753e b841000000 6852010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c40c               | add                 esp, 0xc
            //   85ed                 | test                ebp, ebp
            //   753e                 | jne                 0x40
            //   b841000000           | mov                 eax, 0x41
            //   6852010000           | push                0x152

        $sequence_8 = { 8b4d04 83c102 3bc1 7cef 8b5504 83c202 895704 }
            // n = 7, score = 100
            //   8b4d04               | mov                 ecx, dword ptr [ebp + 4]
            //   83c102               | add                 ecx, 2
            //   3bc1                 | cmp                 eax, ecx
            //   7cef                 | jl                  0xfffffff1
            //   8b5504               | mov                 edx, dword ptr [ebp + 4]
            //   83c202               | add                 edx, 2
            //   895704               | mov                 dword ptr [edi + 4], edx

        $sequence_9 = { 57 e8???????? 83c408 85c0 0f8489000000 8b0f 8b5500 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f8489000000         | je                  0x8f
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   8b5500               | mov                 edx, dword ptr [ebp]

    condition:
        7 of them and filesize < 2015232
}