rule win_amadey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.amadey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.amadey"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5b 8be5 5d c3 5f c6040e00 8bc6 }
            // n = 7, score = 900
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   5f                   | pop                 edi
            //   c6040e00             | mov                 byte ptr [esi + ecx], 0
            //   8bc6                 | mov                 eax, esi

        $sequence_1 = { 57 ff15???????? 85c0 75d9 bb01000000 }
            // n = 5, score = 900
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   75d9                 | jne                 0xffffffdb
            //   bb01000000           | mov                 ebx, 1

        $sequence_2 = { 68???????? eb42 e8???????? 83f801 7431 e8???????? }
            // n = 6, score = 900
            //   68????????           |                     
            //   eb42                 | jmp                 0x44
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1
            //   7431                 | je                  0x33
            //   e8????????           |                     

        $sequence_3 = { 83ec18 8bcc 68???????? e8???????? 8d4db4 }
            // n = 5, score = 900
            //   83ec18               | sub                 esp, 0x18
            //   8bcc                 | mov                 ecx, esp
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]

        $sequence_4 = { 8a0402 88040f 41 8b7dfc 8d4201 }
            // n = 5, score = 900
            //   8a0402               | mov                 al, byte ptr [edx + eax]
            //   88040f               | mov                 byte ptr [edi + ecx], al
            //   41                   | inc                 ecx
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   8d4201               | lea                 eax, [edx + 1]

        $sequence_5 = { 68???????? e8???????? 8d4dcc e8???????? 83c418 }
            // n = 5, score = 900
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

        $sequence_6 = { 0f434d20 40 50 52 6a02 6a00 51 }
            // n = 7, score = 900
            //   0f434d20             | cmovae              ecx, dword ptr [ebp + 0x20]
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   52                   | push                edx
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_7 = { 83f811 7413 e8???????? 83f812 7409 6a01 68???????? }
            // n = 7, score = 900
            //   83f811               | cmp                 eax, 0x11
            //   7413                 | je                  0x15
            //   e8????????           |                     
            //   83f812               | cmp                 eax, 0x12
            //   7409                 | je                  0xb
            //   6a01                 | push                1
            //   68????????           |                     

        $sequence_8 = { 68???????? e8???????? 8d4d98 e8???????? 83c418 }
            // n = 5, score = 800
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

        $sequence_9 = { 8b8d78feffff 42 8bc1 81fa00100000 7214 }
            // n = 5, score = 800
            //   8b8d78feffff         | mov                 ecx, dword ptr [ebp - 0x188]
            //   42                   | inc                 edx
            //   8bc1                 | mov                 eax, ecx
            //   81fa00100000         | cmp                 edx, 0x1000
            //   7214                 | jb                  0x16

        $sequence_10 = { 83fa10 722f 8b8d78feffff 42 }
            // n = 4, score = 800
            //   83fa10               | cmp                 edx, 0x10
            //   722f                 | jb                  0x31
            //   8b8d78feffff         | mov                 ecx, dword ptr [ebp - 0x188]
            //   42                   | inc                 edx

        $sequence_11 = { 8b85f49fffff 40 89442404 8d85f8bfffff 890424 e8???????? }
            // n = 6, score = 700
            //   8b85f49fffff         | mov                 eax, dword ptr [ebp - 0x600c]
            //   40                   | inc                 eax
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8d85f8bfffff         | lea                 eax, [ebp - 0x4008]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_12 = { 8d55c8 89442404 891424 e8???????? 85c0 7523 }
            // n = 6, score = 700
            //   8d55c8               | lea                 edx, [ebp - 0x38]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   891424               | mov                 dword ptr [esp], edx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7523                 | jne                 0x25

        $sequence_13 = { c745fc05000000 c70424???????? e8???????? 890424 e8???????? 84c0 }
            // n = 6, score = 700
            //   c745fc05000000       | mov                 dword ptr [ebp - 4], 5
            //   c70424????????       |                     
            //   e8????????           |                     
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_14 = { 8d85d8fdffff 890424 e8???????? e8???????? 89442404 }
            // n = 5, score = 700
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   e8????????           |                     
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_15 = { 89e5 b828200000 e8???????? 817d08???????? 0f84be000000 }
            // n = 5, score = 700
            //   89e5                 | mov                 ebp, esp
            //   b828200000           | mov                 eax, 0x2028
            //   e8????????           |                     
            //   817d08????????       |                     
            //   0f84be000000         | je                  0xc4

        $sequence_16 = { e8???????? 8b45dc 890424 e8???????? 83ec04 }
            // n = 5, score = 700
            //   e8????????           |                     
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4

        $sequence_17 = { c745fc0c000000 8b45fc c9 c3 }
            // n = 4, score = 700
            //   c745fc0c000000       | mov                 dword ptr [ebp - 4], 0xc
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_18 = { 55 89e5 81ec48040000 e8???????? 89c2 c744241c00020000 8d85f8fbffff }
            // n = 7, score = 700
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   81ec48040000         | sub                 esp, 0x448
            //   e8????????           |                     
            //   89c2                 | mov                 edx, eax
            //   c744241c00020000     | mov                 dword ptr [esp + 0x1c], 0x200
            //   8d85f8fbffff         | lea                 eax, [ebp - 0x408]

        $sequence_19 = { 56 57 8b3d???????? 83ec18 }
            // n = 4, score = 700
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   83ec18               | sub                 esp, 0x18

        $sequence_20 = { 722f 8b8d60feffff 42 8bc1 }
            // n = 4, score = 600
            //   722f                 | jb                  0x31
            //   8b8d60feffff         | mov                 ecx, dword ptr [ebp - 0x1a0]
            //   42                   | inc                 edx
            //   8bc1                 | mov                 eax, ecx

    condition:
        7 of them and filesize < 908288
}