rule win_amtsol_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.amtsol."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.amtsol"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 83ec20 53 56 8b7508 33db 3bf3 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec20               | sub                 esp, 0x20
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33db                 | xor                 ebx, ebx
            //   3bf3                 | cmp                 esi, ebx

        $sequence_1 = { 035e24 8945fc 8b45f8 8d9c1839d0d4d9 53 e8???????? 8b4df0 }
            // n = 7, score = 100
            //   035e24               | add                 ebx, dword ptr [esi + 0x24]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8d9c1839d0d4d9       | lea                 ebx, [eax + ebx - 0x262b2fc7]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_2 = { 836d1010 8b7d10 83e810 8bf0 a5 a5 }
            // n = 6, score = 100
            //   836d1010             | sub                 dword ptr [ebp + 0x10], 0x10
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   83e810               | sub                 eax, 0x10
            //   8bf0                 | mov                 esi, eax
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_3 = { 50 8d4de4 e8???????? 84c0 7418 8d4de4 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7418                 | je                  0x1a
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     

        $sequence_4 = { c6451054 c6451172 c6451261 c645136e c6451473 c6451566 }
            // n = 6, score = 100
            //   c6451054             | mov                 byte ptr [ebp + 0x10], 0x54
            //   c6451172             | mov                 byte ptr [ebp + 0x11], 0x72
            //   c6451261             | mov                 byte ptr [ebp + 0x12], 0x61
            //   c645136e             | mov                 byte ptr [ebp + 0x13], 0x6e
            //   c6451473             | mov                 byte ptr [ebp + 0x14], 0x73
            //   c6451566             | mov                 byte ptr [ebp + 0x15], 0x66

        $sequence_5 = { 3d01010000 7d0d 8a4c181c 8888b82b4200 40 ebe9 }
            // n = 6, score = 100
            //   3d01010000           | cmp                 eax, 0x101
            //   7d0d                 | jge                 0xf
            //   8a4c181c             | mov                 cl, byte ptr [eax + ebx + 0x1c]
            //   8888b82b4200         | mov                 byte ptr [eax + 0x422bb8], cl
            //   40                   | inc                 eax
            //   ebe9                 | jmp                 0xffffffeb

        $sequence_6 = { 53 e8???????? 0345fc 8b4df0 8945f8 8b45f4 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_7 = { 50 e8???????? 59 50 ff7604 e8???????? 83c41c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   ff7604               | push                dword ptr [esi + 4]
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c

        $sequence_8 = { 33cb 030e 8d840878a46ad7 50 e8???????? 0345fc }
            // n = 6, score = 100
            //   33cb                 | xor                 ecx, ebx
            //   030e                 | add                 ecx, dword ptr [esi]
            //   8d840878a46ad7       | lea                 eax, [eax + ecx - 0x28955b88]
            //   50                   | push                eax
            //   e8????????           |                     
            //   0345fc               | add                 eax, dword ptr [ebp - 4]

        $sequence_9 = { 83c040 50 e8???????? 83c40c 8bc6 5e c3 }
            // n = 7, score = 100
            //   83c040               | add                 eax, 0x40
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 335872
}