rule win_anchor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.anchor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.anchor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6400365 eb0a 66c74001646c c640036c }
            // n = 4, score = 800
            //   c6400365             | mov                 byte ptr [eax + 3], 0x65
            //   eb0a                 | jmp                 0xc
            //   66c74001646c         | mov                 word ptr [eax + 1], 0x6c64
            //   c640036c             | mov                 byte ptr [eax + 3], 0x6c

        $sequence_1 = { 740c 66c740016578 c6400365 eb0a }
            // n = 4, score = 800
            //   740c                 | je                  0xe
            //   66c740016578         | mov                 word ptr [eax + 1], 0x7865
            //   c6400365             | mov                 byte ptr [eax + 3], 0x65
            //   eb0a                 | jmp                 0xc

        $sequence_2 = { 8bf8 f7e6 0f90c1 f7d9 0bc8 51 e8???????? }
            // n = 7, score = 600
            //   8bf8                 | mov                 edi, eax
            //   f7e6                 | mul                 esi
            //   0f90c1               | seto                cl
            //   f7d9                 | neg                 ecx
            //   0bc8                 | or                  ecx, eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { c1e102 51 6a00 50 a3???????? e8???????? }
            // n = 6, score = 600
            //   c1e102               | shl                 ecx, 2
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   50                   | push                eax
            //   a3????????           |                     
            //   e8????????           |                     

        $sequence_4 = { b001 5d c3 e9???????? 6a0c 68???????? e8???????? }
            // n = 7, score = 600
            //   b001                 | mov                 eax, edi
            //   5d                   | dec                 eax
            //   c3                   | mov                 ecx, dword ptr [ebp + 0x90]
            //   e9????????           |                     
            //   6a0c                 | dec                 eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_5 = { 66894818 33c9 8b4608 6689581a 8b4608 5b }
            // n = 6, score = 600
            //   66894818             | mov                 word ptr [eax + 0x18], cx
            //   33c9                 | xor                 ecx, ecx
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   6689581a             | mov                 word ptr [eax + 0x1a], bx
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   5b                   | pop                 ebx

        $sequence_6 = { 33c9 8b461c 6689781a 8b461c 5f }
            // n = 5, score = 600
            //   33c9                 | xor                 ecx, ecx
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   6689781a             | mov                 word ptr [eax + 0x1a], di
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   5f                   | pop                 edi

        $sequence_7 = { 50 56 e8???????? 83bde8feffff10 8d85d4feffff }
            // n = 5, score = 600
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   83bde8feffff10       | cmp                 dword ptr [ebp - 0x118], 0x10
            //   8d85d4feffff         | lea                 eax, [ebp - 0x12c]

        $sequence_8 = { b101 e8???????? e8???????? 84c0 }
            // n = 4, score = 600
            //   b101                 | mov                 cl, 1
            //   e8????????           |                     
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_9 = { 0bc1 4898 488d0d12920200 488b5528 }
            // n = 4, score = 200
            //   0bc1                 | dec                 eax
            //   4898                 | mov                 eax, dword ptr [ebp + 0x48]
            //   488d0d12920200       | or                  eax, ecx
            //   488b5528             | dec                 eax

        $sequence_10 = { 4889842440140000 488bd9 4c63d2 498bc2 418be9 48c1f806 488d0db8020100 }
            // n = 7, score = 200
            //   4889842440140000     | dec                 eax
            //   488bd9               | mov                 edi, dword ptr [edx]
            //   4c63d2               | mov                 edx, 0x20
            //   498bc2               | dec                 eax
            //   418be9               | mov                 ecx, edi
            //   48c1f806             | xor                 ebx, ebx
            //   488d0db8020100       | dec                 eax

        $sequence_11 = { 03c2 c1f802 6bc003 894504 }
            // n = 4, score = 200
            //   03c2                 | jne                 0x50b
            //   c1f802               | mov                 byte ptr [ebp + 0x1294], 0
            //   6bc003               | mov                 byte ptr [ebp + 0x12b4], 0
            //   894504               | add                 eax, dword ptr [ebp + 0x24]

        $sequence_12 = { 034524 3b8520010000 760c c785f400000001000000 }
            // n = 4, score = 200
            //   034524               | inc                 ecx
            //   3b8520010000         | mov                 eax, 0x11
            //   760c                 | mov                 edx, 2
            //   c785f400000001000000     | add    byte ptr [edi + ecx], al

        $sequence_13 = { 4881e9c0000000 48c1e108 4803c8 8bc1 488d9405bf090000 eb0c 8bc7 }
            // n = 7, score = 200
            //   4881e9c0000000       | mov                 dword ptr [esp + 0x1440], eax
            //   48c1e108             | dec                 eax
            //   4803c8               | mov                 ebx, ecx
            //   8bc1                 | dec                 esp
            //   488d9405bf090000     | arpl                dx, dx
            //   eb0c                 | dec                 ecx
            //   8bc7                 | mov                 eax, edx

        $sequence_14 = { 0bc1 488b4d48 8801 488b4548 }
            // n = 4, score = 200
            //   0bc1                 | mov                 dword ptr [ebp + 0xa4], eax
            //   488b4d48             | dec                 eax
            //   8801                 | lea                 ecx, [ebp + 0x1a8]
            //   488b4548             | add                 ecx, eax

        $sequence_15 = { 03c8 8bc1 8985a4000000 488d8da8010000 }
            // n = 4, score = 200
            //   03c8                 | mov                 eax, dword ptr [ebp + 0x160]
            //   8bc1                 | dec                 eax
            //   8985a4000000         | mov                 dword ptr [ebp + 0x48], eax
            //   488d8da8010000       | add                 eax, edx

        $sequence_16 = { 498bcf e8???????? 498bc7 488b8d90000000 }
            // n = 4, score = 200
            //   498bcf               | dec                 ecx
            //   e8????????           |                     
            //   498bc7               | mov                 ecx, edi
            //   488b8d90000000       | dec                 ecx

        $sequence_17 = { 7ce8 488b4350 4903d1 b945000000 66890c50 }
            // n = 5, score = 200
            //   7ce8                 | inc                 ecx
            //   488b4350             | mov                 ebp, ecx
            //   4903d1               | dec                 eax
            //   b945000000           | sar                 eax, 6
            //   66890c50             | dec                 eax

        $sequence_18 = { 488bfa 7203 488b3a ba20000000 488bcf e8???????? 33db }
            // n = 7, score = 200
            //   488bfa               | mov                 eax, edi
            //   7203                 | dec                 eax
            //   488b3a               | mov                 ecx, dword ptr [ebp + 0x90]
            //   ba20000000           | dec                 eax
            //   488bcf               | mov                 edi, edx
            //   e8????????           |                     
            //   33db                 | jb                  5

        $sequence_19 = { 00040f 830905 0000 83bd641a0000ff }
            // n = 4, score = 200
            //   00040f               | mov                 ecx, dword ptr [esp + ebx]
            //   830905               | add                 byte ptr [eax], al
            //   0000                 | cmp                 dword ptr [ebp + 0x1a64], -1
            //   83bd641a0000ff       | jne                 0x509

        $sequence_20 = { 05e0930400 894544 8b5544 488b4508 }
            // n = 4, score = 200
            //   05e0930400           | sar                 eax, 2
            //   894544               | imul                eax, eax, 3
            //   8b5544               | mov                 dword ptr [ebp + 4], eax
            //   488b4508             | mov                 eax, dword ptr [ebp + 4]

        $sequence_21 = { 0000 83bd641a0000ff 0f85fc040000 c6859412000000 }
            // n = 4, score = 200
            //   0000                 | shl                 ecx, 8
            //   83bd641a0000ff       | dec                 eax
            //   0f85fc040000         | add                 ecx, eax
            //   c6859412000000       | mov                 eax, ecx

    condition:
        7 of them and filesize < 778240
}