rule win_anchormtea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.anchormtea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.anchormtea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? f7d8 1bc0 83e002 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e002               | and                 eax, 2

        $sequence_1 = { 4883f81f 0f87fd170000 488bce e8???????? 4c8d8b44010000 4c8d05255f0200 }
            // n = 6, score = 100
            //   4883f81f             | mov                 ecx, 4
            //   0f87fd170000         | dec                 esp
            //   488bce               | lea                 eax, [0xcc55]
            //   e8????????           |                     
            //   4c8d8b44010000       | dec                 eax
            //   4c8d05255f0200       | lea                 edx, [0xafc6]

        $sequence_2 = { 898d68f7ffff 89b564f7ffff 3bd0 7741 }
            // n = 4, score = 100
            //   898d68f7ffff         | push                dword ptr [ebp - 0x20]
            //   89b564f7ffff         | mov                 ax, word ptr [ebp - 0x34]
            //   3bd0                 | push                0x824
            //   7741                 | push                ecx

        $sequence_3 = { 8bc2 c1e81f 03c2 8945fc b8619e426b f7e9 }
            // n = 6, score = 100
            //   8bc2                 | lea                 eax, [0x25f25]
            //   c1e81f               | dec                 esp
            //   03c2                 | mov                 dword ptr [esi + 0x10], edi
            //   8945fc               | dec                 ecx
            //   b8619e426b           | add                 eax, ebp
            //   f7e9                 | dec                 eax

        $sequence_4 = { 4533c0 48c7c100000080 897c2420 ff15???????? 85c0 7563 }
            // n = 6, score = 100
            //   4533c0               | inc                 ebp
            //   48c7c100000080       | xor                 eax, eax
            //   897c2420             | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, 0x80000000
            //   7563                 | mov                 dword ptr [esp + 0x20], edi

        $sequence_5 = { 89442450 8b45dc 89542448 418bd2 }
            // n = 4, score = 100
            //   89442450             | arpl                di, sp
            //   8b45dc               | mov                 ebx, ecx
            //   89542448             | dec                 esp
            //   418bd2               | lea                 ecx, [0xcc69]

        $sequence_6 = { 8bd9 4c8d0d69cc0000 b904000000 4c8d0555cc0000 488d15c6af0000 e8???????? }
            // n = 6, score = 100
            //   8bd9                 | inc                 ebp
            //   4c8d0d69cc0000       | test                edi, edi
            //   b904000000           | je                  0xdc
            //   4c8d0555cc0000       | xor                 edi, edi
            //   488d15c6af0000       | dec                 ebp
            //   e8????????           |                     

        $sequence_7 = { 6800010000 ff761c e8???????? ff75e0 668b45cc 6824080000 }
            // n = 6, score = 100
            //   6800010000           | mov                 ecx, ebx
            //   ff761c               | dec                 esp
            //   e8????????           |                     
            //   ff75e0               | lea                 edi, [edx + edx]
            //   668b45cc             | dec                 eax
            //   6824080000           | lea                 ecx, [ebp + 0x40]

        $sequence_8 = { 4585ff 0f84d3000000 33ff 4d63e7 }
            // n = 4, score = 100
            //   4585ff               | dec                 eax
            //   0f84d3000000         | test                eax, eax
            //   33ff                 | je                  0x12
            //   4d63e7               | xor                 edx, edx

        $sequence_9 = { 83c414 c744241000000000 57 ff15???????? }
            // n = 4, score = 100
            //   83c414               | dec                 esp
            //   c744241000000000     | lea                 ecx, [ebx + 0x144]
            //   57                   | dec                 esp
            //   ff15????????         |                     

        $sequence_10 = { ff15???????? 488bf8 4885c0 7410 33d2 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   488bf8               | test                eax, eax
            //   4885c0               | jne                 0x65
            //   7410                 | dec                 eax
            //   33d2                 | mov                 edi, eax

        $sequence_11 = { 55 8bec 81ec8c030000 a1???????? 33c5 8945fc ff05???????? }
            // n = 7, score = 100
            //   55                   | add                 esp, 0x14
            //   8bec                 | mov                 dword ptr [esp + 0x10], 0
            //   81ec8c030000         | push                edi
            //   a1????????           |                     
            //   33c5                 | mov                 eax, edx
            //   8945fc               | shr                 eax, 0x1f
            //   ff05????????         |                     

        $sequence_12 = { c7471c40300010 894714 c7472060300010 c7472480300010 c7472890300010 c7472cb0300010 }
            // n = 6, score = 100
            //   c7471c40300010       | add                 eax, edx
            //   894714               | mov                 dword ptr [ebp - 4], eax
            //   c7472060300010       | mov                 eax, 0x6b429e61
            //   c7472480300010       | imul                ecx
            //   c7472890300010       | push                0x100
            //   c7472cb0300010       | push                dword ptr [esi + 0x1c]

        $sequence_13 = { 51 e8???????? 83c408 8bb70c010000 89b568f7ffff 85f6 0f846c010000 }
            // n = 7, score = 100
            //   51                   | nop                 
            //   e8????????           |                     
            //   83c408               | dec                 ecx
            //   8bb70c010000         | mov                 ecx, ebp
            //   89b568f7ffff         | neg                 eax
            //   85f6                 | sbb                 eax, eax
            //   0f846c010000         | and                 eax, 2

        $sequence_14 = { 4c897e10 4903c5 488bcb 4c8d3c12 }
            // n = 4, score = 100
            //   4c897e10             | mov                 dword ptr [esp + 0x50], eax
            //   4903c5               | mov                 eax, dword ptr [ebp - 0x24]
            //   488bcb               | mov                 dword ptr [esp + 0x48], edx
            //   4c8d3c12             | inc                 ecx

    condition:
        7 of them and filesize < 839680
}