rule win_andromeda_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.andromeda."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.andromeda"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 02d6 81e2ff000000 368a942a00ffffff 301439 41 }
            // n = 5, score = 800
            //   02d6                 | add                 dl, dh
            //   81e2ff000000         | and                 edx, 0xff
            //   368a942a00ffffff     | mov                 dl, byte ptr ss:[edx + ebp - 0x100]
            //   301439               | xor                 byte ptr [ecx + edi], dl
            //   41                   | inc                 ecx

        $sequence_1 = { 8b7508 33db 368a942900ffffff 02c2 }
            // n = 4, score = 800
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33db                 | xor                 ebx, ebx
            //   368a942900ffffff     | mov                 dl, byte ptr ss:[ecx + ebp - 0x100]
            //   02c2                 | add                 al, dl

        $sequence_2 = { 7408 43 3b5d0c 74cf ebcf 33c0 }
            // n = 6, score = 800
            //   7408                 | je                  0xa
            //   43                   | inc                 ebx
            //   3b5d0c               | cmp                 ebx, dword ptr [ebp + 0xc]
            //   74cf                 | je                  0xffffffd1
            //   ebcf                 | jmp                 0xffffffd1
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 55 8bec 81c400ffffff 60 b940000000 8d7dfc b8fcfdfeff }
            // n = 7, score = 800
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c400ffffff         | add                 esp, 0xffffff00
            //   60                   | pushal              
            //   b940000000           | mov                 ecx, 0x40
            //   8d7dfc               | lea                 edi, [ebp - 4]
            //   b8fcfdfeff           | mov                 eax, 0xfffefdfc

        $sequence_4 = { fec0 368a942800ffffff 02da 368ab42b00ffffff 3688b42800ffffff 3688942b00ffffff 02d6 }
            // n = 7, score = 800
            //   fec0                 | inc                 al
            //   368a942800ffffff     | mov                 dl, byte ptr ss:[eax + ebp - 0x100]
            //   02da                 | add                 bl, dl
            //   368ab42b00ffffff     | mov                 dh, byte ptr ss:[ebx + ebp - 0x100]
            //   3688b42800ffffff     | mov                 byte ptr ss:[eax + ebp - 0x100], dh
            //   3688942b00ffffff     | mov                 byte ptr ss:[ebx + ebp - 0x100], dl
            //   02d6                 | add                 dl, dh

        $sequence_5 = { e2f8 fc 33c0 8b7508 }
            // n = 4, score = 800
            //   e2f8                 | loop                0xfffffffa
            //   fc                   | cld                 
            //   33c0                 | xor                 eax, eax
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_6 = { 368ab42800ffffff 3688b42900ffffff 3688942800ffffff fec1 }
            // n = 4, score = 800
            //   368ab42800ffffff     | mov                 dh, byte ptr ss:[eax + ebp - 0x100]
            //   3688b42900ffffff     | mov                 byte ptr ss:[ecx + ebp - 0x100], dh
            //   3688942800ffffff     | mov                 byte ptr ss:[eax + ebp - 0x100], dl
            //   fec1                 | inc                 cl

        $sequence_7 = { 8d7dfc b8fcfdfeff fd ab 2d04040404 e2f8 }
            // n = 6, score = 800
            //   8d7dfc               | lea                 edi, [ebp - 4]
            //   b8fcfdfeff           | mov                 eax, 0xfffefdfc
            //   fd                   | std                 
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   2d04040404           | sub                 eax, 0x4040404
            //   e2f8                 | loop                0xfffffffa

        $sequence_8 = { 60 e8???????? 5d 81ed???????? 33c9 }
            // n = 5, score = 700
            //   60                   | pushal              
            //   e8????????           |                     
            //   5d                   | pop                 ebp
            //   81ed????????         |                     
            //   33c9                 | xor                 ecx, ecx

        $sequence_9 = { 0fb64601 84c0 7905 0d00ffffff }
            // n = 4, score = 400
            //   0fb64601             | movzx               eax, byte ptr [esi + 1]
            //   84c0                 | test                al, al
            //   7905                 | jns                 7
            //   0d00ffffff           | or                  eax, 0xffffff00

        $sequence_10 = { 0f9ec1 33d2 3c41 0f9dc2 85ca 7404 0420 }
            // n = 7, score = 400
            //   0f9ec1               | setle               cl
            //   33d2                 | xor                 edx, edx
            //   3c41                 | cmp                 al, 0x41
            //   0f9dc2               | setge               dl
            //   85ca                 | test                edx, ecx
            //   7404                 | je                  6
            //   0420                 | add                 al, 0x20

        $sequence_11 = { 8a06 33c9 3c5a 0f9ec1 33d2 3c41 }
            // n = 6, score = 400
            //   8a06                 | mov                 al, byte ptr [esi]
            //   33c9                 | xor                 ecx, ecx
            //   3c5a                 | cmp                 al, 0x5a
            //   0f9ec1               | setle               cl
            //   33d2                 | xor                 edx, edx
            //   3c41                 | cmp                 al, 0x41

        $sequence_12 = { 8d45d0 50 6a01 ff7508 }
            // n = 4, score = 400
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_13 = { 50 e8???????? 83c40c 6800000100 e8???????? }
            // n = 5, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6800000100           | push                0x10000
            //   e8????????           |                     

        $sequence_14 = { 68???????? 50 ff15???????? 83c40c 56 6880000000 }
            // n = 6, score = 300
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   6880000000           | push                0x80

        $sequence_15 = { 689f010000 6811010000 57 68???????? ff15???????? 50 }
            // n = 6, score = 300
            //   689f010000           | push                0x19f
            //   6811010000           | push                0x111
            //   57                   | push                edi
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_16 = { 68401f0000 e8???????? 668945e2 c745e400000000 }
            // n = 4, score = 200
            //   68401f0000           | push                0x1f40
            //   e8????????           |                     
            //   668945e2             | mov                 word ptr [ebp - 0x1e], ax
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0

        $sequence_17 = { c745e400000000 6a00 6a00 6a00 6a06 6a01 6a02 }
            // n = 7, score = 200
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a06                 | push                6
            //   6a01                 | push                1
            //   6a02                 | push                2

        $sequence_18 = { c7459c44000000 8945d4 8945d8 8945dc 66c745cc0000 c745c801010000 8d458c }
            // n = 7, score = 200
            //   c7459c44000000       | mov                 dword ptr [ebp - 0x64], 0x44
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   66c745cc0000         | mov                 word ptr [ebp - 0x34], 0
            //   c745c801010000       | mov                 dword ptr [ebp - 0x38], 0x101
            //   8d458c               | lea                 eax, [ebp - 0x74]

        $sequence_19 = { 7457 33c0 8d7d9c b944000000 f3aa 6a00 6a00 }
            // n = 7, score = 200
            //   7457                 | je                  0x59
            //   33c0                 | xor                 eax, eax
            //   8d7d9c               | lea                 edi, [ebp - 0x64]
            //   b944000000           | mov                 ecx, 0x44
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_20 = { e8???????? ff75f4 e8???????? 68???????? 6801010000 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   68????????           |                     
            //   6801010000           | push                0x101
            //   e8????????           |                     

        $sequence_21 = { 6a02 e8???????? 8945f0 83f8ff 7479 }
            // n = 5, score = 200
            //   6a02                 | push                2
            //   e8????????           |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   83f8ff               | cmp                 eax, -1
            //   7479                 | je                  0x7b

        $sequence_22 = { e8???????? 8945f8 83f800 0f8458010000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   83f800               | cmp                 eax, 0
            //   0f8458010000         | je                  0x15e

        $sequence_23 = { 6804010000 ff75fc 6a00 e8???????? 6a00 ff75f8 }
            // n = 6, score = 200
            //   6804010000           | push                0x104
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6a00                 | push                0
            //   e8????????           |                     
            //   6a00                 | push                0
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_24 = { 81fb5267a723 0f843fffffff 56 ff7514 }
            // n = 4, score = 100
            //   81fb5267a723         | cmp                 ebx, 0x23a76752
            //   0f843fffffff         | je                  0xffffff45
            //   56                   | push                esi
            //   ff7514               | push                dword ptr [ebp + 0x14]

        $sequence_25 = { 0faff8 69f677adcc8a 81ffd02eaced 0f84a1feffff e9???????? 803beb }
            // n = 6, score = 100
            //   0faff8               | imul                edi, eax
            //   69f677adcc8a         | imul                esi, esi, 0x8accad77
            //   81ffd02eaced         | cmp                 edi, 0xedac2ed0
            //   0f84a1feffff         | je                  0xfffffea7
            //   e9????????           |                     
            //   803beb               | cmp                 byte ptr [ebx], 0xeb

        $sequence_26 = { 81e604002402 81e747af3c96 81ce00008000 81c760345938 }
            // n = 4, score = 100
            //   81e604002402         | and                 esi, 0x2240004
            //   81e747af3c96         | and                 edi, 0x963caf47
            //   81ce00008000         | or                  esi, 0x800000
            //   81c760345938         | add                 edi, 0x38593460

        $sequence_27 = { 8b4574 833800 0f846c010000 6af5 ff5510 }
            // n = 5, score = 100
            //   8b4574               | mov                 eax, dword ptr [ebp + 0x74]
            //   833800               | cmp                 dword ptr [eax], 0
            //   0f846c010000         | je                  0x172
            //   6af5                 | push                -0xb
            //   ff5510               | call                dword ptr [ebp + 0x10]

        $sequence_28 = { ff5614 8bd8 81f392be3437 81ff64e62722 0f8418010000 8365f000 6850020000 }
            // n = 7, score = 100
            //   ff5614               | call                dword ptr [esi + 0x14]
            //   8bd8                 | mov                 ebx, eax
            //   81f392be3437         | xor                 ebx, 0x3734be92
            //   81ff64e62722         | cmp                 edi, 0x2227e664
            //   0f8418010000         | je                  0x11e
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0
            //   6850020000           | push                0x250

        $sequence_29 = { ff5638 314508 ff560c 8b7d04 0bd8 81fbb599839e 7503 }
            // n = 7, score = 100
            //   ff5638               | call                dword ptr [esi + 0x38]
            //   314508               | xor                 dword ptr [ebp + 8], eax
            //   ff560c               | call                dword ptr [esi + 0xc]
            //   8b7d04               | mov                 edi, dword ptr [ebp + 4]
            //   0bd8                 | or                  ebx, eax
            //   81fbb599839e         | cmp                 ebx, 0x9e8399b5
            //   7503                 | jne                 5

        $sequence_30 = { 81f99cd8b976 7417 85db 7c73 }
            // n = 4, score = 100
            //   81f99cd8b976         | cmp                 ecx, 0x76b9d89c
            //   7417                 | je                  0x19
            //   85db                 | test                ebx, ebx
            //   7c73                 | jl                  0x75

        $sequence_31 = { ff5518 33f8 81f6acec75ce 81ff45ee1de6 0f84ce000000 837d4800 }
            // n = 6, score = 100
            //   ff5518               | call                dword ptr [ebp + 0x18]
            //   33f8                 | xor                 edi, eax
            //   81f6acec75ce         | xor                 esi, 0xce75ecac
            //   81ff45ee1de6         | cmp                 edi, 0xe61dee45
            //   0f84ce000000         | je                  0xd4
            //   837d4800             | cmp                 dword ptr [ebp + 0x48], 0

    condition:
        7 of them and filesize < 204800
}