rule win_anel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.anel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.anel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebc4 395dc4 7515 8b4594 83c0c8 50 8d4580 }
            // n = 7, score = 200
            //   ebc4                 | jmp                 0xffffffc6
            //   395dc4               | cmp                 dword ptr [ebp - 0x3c], ebx
            //   7515                 | jne                 0x17
            //   8b4594               | mov                 eax, dword ptr [ebp - 0x6c]
            //   83c0c8               | add                 eax, -0x38
            //   50                   | push                eax
            //   8d4580               | lea                 eax, [ebp - 0x80]

        $sequence_1 = { 83781410 897810 7202 8b00 c60000 39bb3c020000 }
            // n = 6, score = 200
            //   83781410             | cmp                 dword ptr [eax + 0x14], 0x10
            //   897810               | mov                 dword ptr [eax + 0x10], edi
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   c60000               | mov                 byte ptr [eax], 0
            //   39bb3c020000         | cmp                 dword ptr [ebx + 0x23c], edi

        $sequence_2 = { 7403 33db 43 899fd4010000 6a01 33ff 8d750c }
            // n = 7, score = 200
            //   7403                 | je                  5
            //   33db                 | xor                 ebx, ebx
            //   43                   | inc                 ebx
            //   899fd4010000         | mov                 dword ptr [edi + 0x1d4], ebx
            //   6a01                 | push                1
            //   33ff                 | xor                 edi, edi
            //   8d750c               | lea                 esi, [ebp + 0xc]

        $sequence_3 = { 53 8d45c4 33ff 50 895dfc 47 6802000080 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   33ff                 | xor                 edi, edi
            //   50                   | push                eax
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   47                   | inc                 edi
            //   6802000080           | push                0x80000002

        $sequence_4 = { 7477 03fe 57 8d857cffffff 50 53 e8???????? }
            // n = 7, score = 200
            //   7477                 | je                  0x79
            //   03fe                 | add                 edi, esi
            //   57                   | push                edi
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_5 = { 68???????? 50 e8???????? 83c410 8d45d0 50 e8???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 6a00 8bd0 8d8c24b0000000 c684245c01000005 e8???????? 53 33ff }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   8bd0                 | mov                 edx, eax
            //   8d8c24b0000000       | lea                 ecx, [esp + 0xb0]
            //   c684245c01000005     | mov                 byte ptr [esp + 0x15c], 5
            //   e8????????           |                     
            //   53                   | push                ebx
            //   33ff                 | xor                 edi, edi

        $sequence_7 = { 837f1410 7202 8b3f 8d442450 50 57 e8???????? }
            // n = 7, score = 200
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_8 = { 8d7dd0 a5 a5 a5 a5 8b75f0 8bfb }
            // n = 7, score = 200
            //   8d7dd0               | lea                 edi, [ebp - 0x30]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   8bfb                 | mov                 edi, ebx

        $sequence_9 = { 837f1410 7204 8b07 eb02 8bc7 8d3418 56 }
            // n = 7, score = 200
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10
            //   7204                 | jb                  6
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi
            //   8d3418               | lea                 esi, [eax + ebx]
            //   56                   | push                esi

    condition:
        7 of them and filesize < 376832
}