rule win_aperetif_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.aperetif."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aperetif"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7708 50 e8???????? 83c40c ff7708 8b442418 50 }
            // n = 7, score = 100
            //   ff7708               | push                dword ptr [edi + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff7708               | push                dword ptr [edi + 8]
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   50                   | push                eax

        $sequence_1 = { f20f1186080b0000 c7452400000000 e9???????? 85c9 0f84d8050000 697528100b0000 33ff }
            // n = 7, score = 100
            //   f20f1186080b0000     | movsd               qword ptr [esi + 0xb08], xmm0
            //   c7452400000000       | mov                 dword ptr [ebp + 0x24], 0
            //   e9????????           |                     
            //   85c9                 | test                ecx, ecx
            //   0f84d8050000         | je                  0x5de
            //   697528100b0000       | imul                esi, dword ptr [ebp + 0x28], 0xb10
            //   33ff                 | xor                 edi, edi

        $sequence_2 = { 8bef 8d041b 50 8b442414 8b401c ff30 ff742424 }
            // n = 7, score = 100
            //   8bef                 | mov                 ebp, edi
            //   8d041b               | lea                 eax, [ebx + ebx]
            //   50                   | push                eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8b401c               | mov                 eax, dword ptr [eax + 0x1c]
            //   ff30                 | push                dword ptr [eax]
            //   ff742424             | push                dword ptr [esp + 0x24]

        $sequence_3 = { e8???????? 8d48fe b82d000000 668901 eb0c 50 8d45ee }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d48fe               | lea                 ecx, [eax - 2]
            //   b82d000000           | mov                 eax, 0x2d
            //   668901               | mov                 word ptr [ecx], ax
            //   eb0c                 | jmp                 0xe
            //   50                   | push                eax
            //   8d45ee               | lea                 eax, [ebp - 0x12]

        $sequence_4 = { e8???????? 8bf0 83c410 85f6 7511 68db020000 68???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c410               | add                 esp, 0x10
            //   85f6                 | test                esi, esi
            //   7511                 | jne                 0x13
            //   68db020000           | push                0x2db
            //   68????????           |                     

        $sequence_5 = { 8bc1 c1e810 0fb6c0 c1e208 0fb68068b98700 0bd0 8bc1 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   c1e810               | shr                 eax, 0x10
            //   0fb6c0               | movzx               eax, al
            //   c1e208               | shl                 edx, 8
            //   0fb68068b98700       | movzx               eax, byte ptr [eax + 0x87b968]
            //   0bd0                 | or                  edx, eax
            //   8bc1                 | mov                 eax, ecx

        $sequence_6 = { 8b5604 83c604 85d2 0f8421010000 8d4a01 8bc2 f00fb10e }
            // n = 7, score = 100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   83c604               | add                 esi, 4
            //   85d2                 | test                edx, edx
            //   0f8421010000         | je                  0x127
            //   8d4a01               | lea                 ecx, [edx + 1]
            //   8bc2                 | mov                 eax, edx
            //   f00fb10e             | lock cmpxchg        dword ptr [esi], ecx

        $sequence_7 = { f20f5ec8 0f28d1 f20f59cb f20f59542448 660f2f0d???????? 7740 f20f1005???????? }
            // n = 7, score = 100
            //   f20f5ec8             | divsd               xmm1, xmm0
            //   0f28d1               | movaps              xmm2, xmm1
            //   f20f59cb             | mulsd               xmm1, xmm3
            //   f20f59542448         | mulsd               xmm2, qword ptr [esp + 0x48]
            //   660f2f0d????????     |                     
            //   7740                 | ja                  0x42
            //   f20f1005????????     |                     

        $sequence_8 = { ff7508 8910 8b55e8 897004 895008 e8???????? c74310507c5c00 }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8910                 | mov                 dword ptr [eax], edx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   e8????????           |                     
            //   c74310507c5c00       | mov                 dword ptr [ebx + 0x10], 0x5c7c50

        $sequence_9 = { eb46 8b01 52 8d55d4 c745fc00000000 52 ff5014 }
            // n = 7, score = 100
            //   eb46                 | jmp                 0x48
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   52                   | push                edx
            //   8d55d4               | lea                 edx, [ebp - 0x2c]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   52                   | push                edx
            //   ff5014               | call                dword ptr [eax + 0x14]

    condition:
        7 of them and filesize < 10500096
}