rule win_apocalipto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.apocalipto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.apocalipto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec48 c745f400000000 8d45f4 89442410 c744240c1c000000 8d45d8 }
            // n = 6, score = 100
            //   83ec48               | sub                 esp, 0x48
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   c744240c1c000000     | mov                 dword ptr [esp + 0xc], 0x1c
            //   8d45d8               | lea                 eax, [ebp - 0x28]

        $sequence_1 = { 85c0 0f8433090000 c7442404???????? 891c24 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   0f8433090000         | je                  0x939
            //   c7442404????????     |                     
            //   891c24               | mov                 dword ptr [esp], ebx

        $sequence_2 = { 745f 31db 6690 43 }
            // n = 4, score = 100
            //   745f                 | je                  0x61
            //   31db                 | xor                 ebx, ebx
            //   6690                 | nop                 
            //   43                   | inc                 ebx

        $sequence_3 = { 31c0 85ff 75d9 8945f0 31db 31c9 }
            // n = 6, score = 100
            //   31c0                 | xor                 eax, eax
            //   85ff                 | test                edi, edi
            //   75d9                 | jne                 0xffffffdb
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   31db                 | xor                 ebx, ebx
            //   31c9                 | xor                 ecx, ecx

        $sequence_4 = { 0500100000 8985d0f3ffff c744240c04000000 c744240800100000 89442404 }
            // n = 5, score = 100
            //   0500100000           | add                 eax, 0x1000
            //   8985d0f3ffff         | mov                 dword ptr [ebp - 0xc30], eax
            //   c744240c04000000     | mov                 dword ptr [esp + 0xc], 4
            //   c744240800100000     | mov                 dword ptr [esp + 8], 0x1000
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_5 = { c744241800000000 c744241404000000 c744241000000000 c744240c00000000 c744240800000000 8b5508 }
            // n = 6, score = 100
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0
            //   c744241404000000     | mov                 dword ptr [esp + 0x14], 4
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_6 = { e9???????? ff15???????? 89c6 c705????????01000000 c7442404???????? 890424 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   ff15????????         |                     
            //   89c6                 | mov                 esi, eax
            //   c705????????01000000     |     
            //   c7442404????????     |                     
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_7 = { 890424 ff15???????? 50 c744240800400000 895c2404 }
            // n = 5, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   ff15????????         |                     
            //   50                   | push                eax
            //   c744240800400000     | mov                 dword ptr [esp + 8], 0x4000
            //   895c2404             | mov                 dword ptr [esp + 4], ebx

        $sequence_8 = { 8974bb08 41 81f900010000 75cf c7430400000000 c70300000000 }
            // n = 6, score = 100
            //   8974bb08             | mov                 dword ptr [ebx + edi*4 + 8], esi
            //   41                   | inc                 ecx
            //   81f900010000         | cmp                 ecx, 0x100
            //   75cf                 | jne                 0xffffffd1
            //   c7430400000000       | mov                 dword ptr [ebx + 4], 0
            //   c70300000000         | mov                 dword ptr [ebx], 0

        $sequence_9 = { a3???????? 85c0 0f84510a0000 c7442404???????? 891c24 ff15???????? 83ec08 }
            // n = 7, score = 100
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84510a0000         | je                  0xa57
            //   c7442404????????     |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   ff15????????         |                     
            //   83ec08               | sub                 esp, 8

    condition:
        7 of them and filesize < 212992
}