rule win_apocalypse_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.apocalypse_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.apocalypse_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800010000 6a00 6a00 6a00 8d4c2424 51 6880000000 }
            // n = 7, score = 200
            //   6800010000           | push                0x100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   51                   | push                ecx
            //   6880000000           | push                0x80

        $sequence_1 = { 8d4c2414 51 ffd7 03c0 50 8b442414 }
            // n = 6, score = 200
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   ffd7                 | call                edi
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_2 = { 8bc3 e8???????? 6a04 6800100000 68ff7f0000 6a00 }
            // n = 6, score = 200
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   6a04                 | push                4
            //   6800100000           | push                0x1000
            //   68ff7f0000           | push                0x7fff
            //   6a00                 | push                0

        $sequence_3 = { 8b2d???????? 52 ffd5 8d442410 }
            // n = 4, score = 200
            //   8b2d????????         |                     
            //   52                   | push                edx
            //   ffd5                 | call                ebp
            //   8d442410             | lea                 eax, [esp + 0x10]

        $sequence_4 = { ff15???????? 6a03 56 ff15???????? 56 ff15???????? 5f }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   6a03                 | push                3
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   5f                   | pop                 edi

        $sequence_5 = { 51 68???????? 6801000080 ffd6 8b3d???????? 8d542414 52 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ffd6                 | call                esi
            //   8b3d????????         |                     
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   52                   | push                edx

        $sequence_6 = { 8d542444 52 56 68???????? 8d842474020000 50 eb13 }
            // n = 7, score = 200
            //   8d542444             | lea                 edx, [esp + 0x44]
            //   52                   | push                edx
            //   56                   | push                esi
            //   68????????           |                     
            //   8d842474020000       | lea                 eax, [esp + 0x274]
            //   50                   | push                eax
            //   eb13                 | jmp                 0x15

        $sequence_7 = { 6a00 6880000000 6a03 6a00 6a01 6800000080 8d4c2440 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6800000080           | push                0x80000000
            //   8d4c2440             | lea                 ecx, [esp + 0x40]

        $sequence_8 = { 6801000080 ffd6 8b3d???????? 8d542414 52 ffd7 8b4c2410 }
            // n = 7, score = 200
            //   6801000080           | push                0x80000001
            //   ffd6                 | call                esi
            //   8b3d????????         |                     
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_9 = { 743b 56 68???????? ffd5 83c408 6a00 6a00 }
            // n = 7, score = 200
            //   743b                 | je                  0x3d
            //   56                   | push                esi
            //   68????????           |                     
            //   ffd5                 | call                ebp
            //   83c408               | add                 esp, 8
            //   6a00                 | push                0
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 40960
}