rule win_ariabody_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ariabody."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ariabody"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3ac3 7402 32c3 88040a }
            // n = 4, score = 300
            //   3ac3                 | cmp                 al, bl
            //   7402                 | je                  4
            //   32c3                 | xor                 al, bl
            //   88040a               | mov                 byte ptr [edx + ecx], al

        $sequence_1 = { 8bd9 e8???????? 8bf8 893b }
            // n = 4, score = 300
            //   8bd9                 | mov                 ebx, ecx
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   893b                 | mov                 dword ptr [ebx], edi

        $sequence_2 = { 8d55fc 03f9 e8???????? 59 85c0 }
            // n = 5, score = 300
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   03f9                 | add                 edi, ecx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_3 = { 0138 115804 eb02 0138 }
            // n = 4, score = 300
            //   0138                 | add                 dword ptr [eax], edi
            //   115804               | adc                 dword ptr [eax + 4], ebx
            //   eb02                 | jmp                 4
            //   0138                 | add                 dword ptr [eax], edi

        $sequence_4 = { 55 8bec 83ec50 53 57 8bd9 }
            // n = 6, score = 300
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec50               | sub                 esp, 0x50
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8bd9                 | mov                 ebx, ecx

        $sequence_5 = { ff75d9 8d45cc 50 57 }
            // n = 4, score = 300
            //   ff75d9               | push                dword ptr [ebp - 0x27]
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_6 = { 56 8d0c30 ffd1 8bc6 5f }
            // n = 5, score = 300
            //   56                   | push                esi
            //   8d0c30               | lea                 ecx, [eax + esi]
            //   ffd1                 | call                ecx
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi

        $sequence_7 = { 8bf8 893e eb13 8b16 8bcf }
            // n = 5, score = 300
            //   8bf8                 | mov                 edi, eax
            //   893e                 | mov                 dword ptr [esi], edi
            //   eb13                 | jmp                 0x15
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8bcf                 | mov                 ecx, edi

        $sequence_8 = { 448850d2 448850d3 448850d4 448850d5 448850d6 448858d7 }
            // n = 6, score = 100
            //   448850d2             | inc                 esp
            //   448850d3             | mov                 byte ptr [eax - 0x2e], dl
            //   448850d4             | inc                 esp
            //   448850d5             | mov                 byte ptr [eax - 0x2d], dl
            //   448850d6             | inc                 esp
            //   448858d7             | mov                 byte ptr [eax - 0x2c], dl

        $sequence_9 = { 33d2 4c8d4c2420 4d895108 4889f1 4533c0 ff9550010000 4c8b542428 }
            // n = 7, score = 100
            //   33d2                 | dec                 eax
            //   4c8d4c2420           | mov                 ecx, 0x80000003
            //   4d895108             | xor                 edx, edx
            //   4889f1               | dec                 esp
            //   4533c0               | lea                 eax, [esp + 0x98]
            //   ff9550010000         | dec                 esp
            //   4c8b542428           | lea                 ecx, [esp + 0x1bc]

        $sequence_10 = { e8???????? ba0a000000 4c8d15e189ffff 385558 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   ba0a000000           | inc                 esp
            //   4c8d15e189ffff       | mov                 byte ptr [eax - 0x2b], dl
            //   385558               | inc                 esp

        $sequence_11 = { 415c 5f 5e c3 4c89e2 }
            // n = 5, score = 100
            //   415c                 | dec                 esp
            //   5f                   | mov                 dword ptr [eax + 0x20], esi
            //   5e                   | dec                 esp
            //   c3                   | mov                 dword ptr [eax + 0x28], esi
            //   4c89e2               | dec                 eax

        $sequence_12 = { 48c7c103000080 33d2 4c8d842498000000 4c8d8c24bc010000 4c897020 4c897028 }
            // n = 6, score = 100
            //   48c7c103000080       | lea                 ecx, [esp + 0x98]
            //   33d2                 | dec                 eax
            //   4c8d842498000000     | lea                 edx, [esp + 0x48]
            //   4c8d8c24bc010000     | call                dword ptr [ebp + 0x1b8]
            //   4c897020             | dec                 ecx
            //   4c897028             | mov                 edx, esp

        $sequence_13 = { c78424bc01000000010000 488d8c2498000000 488d542448 ff95b8010000 4989e2 }
            // n = 5, score = 100
            //   c78424bc01000000010000     | mov    byte ptr [eax - 0x2a], dl
            //   488d8c2498000000     | inc                 esp
            //   488d542448           | mov                 byte ptr [eax - 0x29], bl
            //   ff95b8010000         | mov                 edx, 0xa
            //   4989e2               | dec                 esp

        $sequence_14 = { 85c0 752e 4889e9 4889f2 }
            // n = 4, score = 100
            //   85c0                 | lea                 edx, [0xffff89e1]
            //   752e                 | cmp                 byte ptr [ebp + 0x58], dl
            //   4889e9               | mov                 dword ptr [esp + 0x1bc], 0x100
            //   4889f2               | dec                 eax

        $sequence_15 = { 4889742448 4489de 48897c2440 4489d7 4c89642438 4189c4 }
            // n = 6, score = 100
            //   4889742448           | test                eax, eax
            //   4489de               | jne                 0x30
            //   48897c2440           | dec                 eax
            //   4489d7               | mov                 ecx, ebp
            //   4c89642438           | dec                 eax
            //   4189c4               | mov                 edx, esi

    condition:
        7 of them and filesize < 253952
}