rule win_arkei_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.arkei_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.arkei_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f849ffeffff ba424d0000 668955ec 8b4620 8b0e 8d1481 }
            // n = 6, score = 400
            //   0f849ffeffff         | je                  0xfffffea5
            //   ba424d0000           | mov                 edx, 0x4d42
            //   668955ec             | mov                 word ptr [ebp - 0x14], dx
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8d1481               | lea                 edx, [ecx + eax*4]

        $sequence_1 = { 57 57 68000000c0 68???????? ff15???????? 8bf8 }
            // n = 6, score = 400
            //   57                   | push                edi
            //   57                   | push                edi
            //   68000000c0           | push                0xc0000000
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_2 = { 52 57 8945f6 ff15???????? 85c0 0f8458feffff 8b4e20 }
            // n = 7, score = 400
            //   52                   | push                edx
            //   57                   | push                edi
            //   8945f6               | mov                 dword ptr [ebp - 0xa], eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8458feffff         | je                  0xfffffe5e
            //   8b4e20               | mov                 ecx, dword ptr [esi + 0x20]

        $sequence_3 = { 6689460c 668b4dd6 66894e0e 6683fb18 }
            // n = 4, score = 400
            //   6689460c             | mov                 word ptr [esi + 0xc], ax
            //   668b4dd6             | mov                 cx, word ptr [ebp - 0x2a]
            //   66894e0e             | mov                 word ptr [esi + 0xe], cx
            //   6683fb18             | cmp                 bx, 0x18

        $sequence_4 = { ff15???????? 85c0 74be 8b45e0 }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   74be                 | je                  0xffffffc0
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_5 = { 8d55ec 52 57 8945f6 }
            // n = 4, score = 400
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   52                   | push                edx
            //   57                   | push                edi
            //   8945f6               | mov                 dword ptr [ebp - 0xa], eax

        $sequence_6 = { 895608 668b45d4 6689460c 668b4dd6 66894e0e }
            // n = 5, score = 400
            //   895608               | mov                 dword ptr [esi + 8], edx
            //   668b45d4             | mov                 ax, word ptr [ebp - 0x2c]
            //   6689460c             | mov                 word ptr [esi + 0xc], ax
            //   668b4dd6             | mov                 cx, word ptr [ebp - 0x2a]
            //   66894e0e             | mov                 word ptr [esi + 0xe], cx

        $sequence_7 = { 8b16 8d448a0e 6a00 8d4de4 51 6a0e }
            // n = 6, score = 400
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8d448a0e             | lea                 eax, [edx + ecx*4 + 0xe]
            //   6a00                 | push                0
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   51                   | push                ecx
            //   6a0e                 | push                0xe

        $sequence_8 = { 74be 8b45e0 8d55c4 52 6a18 50 }
            // n = 6, score = 400
            //   74be                 | je                  0xffffffc0
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8d55c4               | lea                 edx, [ebp - 0x3c]
            //   52                   | push                edx
            //   6a18                 | push                0x18
            //   50                   | push                eax

        $sequence_9 = { 57 8945e8 ffd3 6a0a 57 8bf0 }
            // n = 6, score = 400
            //   57                   | push                edi
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   ffd3                 | call                ebx
            //   6a0a                 | push                0xa
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 1744896
}