rule win_artra_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.artra."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.artra"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75cc 5d 5b 8b442410 5f 5e 83c41c }
            // n = 7, score = 800
            //   75cc                 | jne                 0xffffffce
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c41c               | add                 esp, 0x1c

        $sequence_1 = { 5f 8a08 40 84c9 75f9 2bc2 880c30 }
            // n = 7, score = 800
            //   5f                   | pop                 edi
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc2                 | sub                 eax, edx
            //   880c30               | mov                 byte ptr [eax + esi], cl

        $sequence_2 = { 5f 5e 83c41c c21000 5f 33c0 }
            // n = 6, score = 800
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c41c               | add                 esp, 0x1c
            //   c21000               | ret                 0x10
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 57 33c9 8d7801 8da42400000000 8a10 40 84d2 }
            // n = 7, score = 800
            //   57                   | push                edi
            //   33c9                 | xor                 ecx, ecx
            //   8d7801               | lea                 edi, [eax + 1]
            //   8da42400000000       | lea                 esp, [esp]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84d2                 | test                dl, dl

        $sequence_4 = { 2bc7 3bc8 72e3 8bc6 8d5001 5f }
            // n = 6, score = 800
            //   2bc7                 | sub                 eax, edi
            //   3bc8                 | cmp                 ecx, eax
            //   72e3                 | jb                  0xffffffe5
            //   8bc6                 | mov                 eax, esi
            //   8d5001               | lea                 edx, [eax + 1]
            //   5f                   | pop                 edi

        $sequence_5 = { 800431f3 8bc6 41 8d7801 8d9b00000000 }
            // n = 5, score = 800
            //   800431f3             | add                 byte ptr [ecx + esi], 0xf3
            //   8bc6                 | mov                 eax, esi
            //   41                   | inc                 ecx
            //   8d7801               | lea                 edi, [eax + 1]
            //   8d9b00000000         | lea                 ebx, [ebx]

        $sequence_6 = { e8???????? 8b3d???????? 6a00 6a00 6a00 8d442414 }
            // n = 6, score = 600
            //   e8????????           |                     
            //   8b3d????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d442414             | lea                 eax, [esp + 0x14]

        $sequence_7 = { ff15???????? 8bf8 85ff 0f8488000000 6a00 57 ff15???????? }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f8488000000         | je                  0x8e
            //   6a00                 | push                0
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_8 = { 8d8c2420010000 51 8d542418 52 8d442420 50 }
            // n = 6, score = 600
            //   8d8c2420010000       | lea                 ecx, [esp + 0x120]
            //   51                   | push                ecx
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   52                   | push                edx
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax

        $sequence_9 = { 2bc2 03fb 8a4f01 47 }
            // n = 4, score = 600
            //   2bc2                 | sub                 eax, edx
            //   03fb                 | add                 edi, ebx
            //   8a4f01               | mov                 cl, byte ptr [edi + 1]
            //   47                   | inc                 edi

        $sequence_10 = { 40 42 84c9 75f6 e8???????? }
            // n = 5, score = 600
            //   40                   | inc                 eax
            //   42                   | inc                 edx
            //   84c9                 | test                cl, cl
            //   75f6                 | jne                 0xfffffff8
            //   e8????????           |                     

        $sequence_11 = { 8bf0 8bd1 83c404 2bf2 90 8a11 88140e }
            // n = 7, score = 600
            //   8bf0                 | mov                 esi, eax
            //   8bd1                 | mov                 edx, ecx
            //   83c404               | add                 esp, 4
            //   2bf2                 | sub                 esi, edx
            //   90                   | nop                 
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   88140e               | mov                 byte ptr [esi + ecx], dl

        $sequence_12 = { 90 8b542410 8d4c2410 51 56 52 ffd3 }
            // n = 7, score = 600
            //   90                   | nop                 
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   52                   | push                edx
            //   ffd3                 | call                ebx

        $sequence_13 = { 53 8b1d???????? 55 8b2d???????? 90 }
            // n = 5, score = 600
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   55                   | push                ebp
            //   8b2d????????         |                     
            //   90                   | nop                 

        $sequence_14 = { e8???????? 8d442458 83c410 8bc8 }
            // n = 4, score = 600
            //   e8????????           |                     
            //   8d442458             | lea                 eax, [esp + 0x58]
            //   83c410               | add                 esp, 0x10
            //   8bc8                 | mov                 ecx, eax

        $sequence_15 = { 6a00 8d54241c 52 ffd7 85c0 75cc 5d }
            // n = 7, score = 600
            //   6a00                 | push                0
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   75cc                 | jne                 0xffffffce
            //   5d                   | pop                 ebp

        $sequence_16 = { 6a00 8d442414 50 ffd7 85c0 7445 }
            // n = 6, score = 600
            //   6a00                 | push                0
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7445                 | je                  0x47

        $sequence_17 = { 7205 e8???????? 8b7c2414 8b4f3c 8b11 8b5214 8d44241c }
            // n = 7, score = 600
            //   7205                 | jb                  7
            //   e8????????           |                     
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   8b4f3c               | mov                 ecx, dword ptr [edi + 0x3c]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b5214               | mov                 edx, dword ptr [edx + 0x14]
            //   8d44241c             | lea                 eax, [esp + 0x1c]

        $sequence_18 = { 2c61 3c05 7733 885c2c18 45 83fd02 7529 }
            // n = 7, score = 400
            //   2c61                 | sub                 al, 0x61
            //   3c05                 | cmp                 al, 5
            //   7733                 | ja                  0x35
            //   885c2c18             | mov                 byte ptr [esp + ebp + 0x18], bl
            //   45                   | inc                 ebp
            //   83fd02               | cmp                 ebp, 2
            //   7529                 | jne                 0x2b

        $sequence_19 = { 8810 40 83ee01 75f3 b8???????? c6042f00 8d5001 }
            // n = 7, score = 400
            //   8810                 | mov                 byte ptr [eax], dl
            //   40                   | inc                 eax
            //   83ee01               | sub                 esi, 1
            //   75f3                 | jne                 0xfffffff5
            //   b8????????           |                     
            //   c6042f00             | mov                 byte ptr [edi + ebp], 0
            //   8d5001               | lea                 edx, [eax + 1]

        $sequence_20 = { c1f805 8bcf 83e11f c1e106 8b0485e03b4100 c644080401 57 }
            // n = 7, score = 400
            //   c1f805               | sar                 eax, 5
            //   8bcf                 | mov                 ecx, edi
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   8b0485e03b4100       | mov                 eax, dword ptr [eax*4 + 0x413be0]
            //   c644080401           | mov                 byte ptr [eax + ecx + 4], 1
            //   57                   | push                edi

        $sequence_21 = { c21000 a1???????? 6a00 68???????? 56 6a67 50 }
            // n = 7, score = 400
            //   c21000               | ret                 0x10
            //   a1????????           |                     
            //   6a00                 | push                0
            //   68????????           |                     
            //   56                   | push                esi
            //   6a67                 | push                0x67
            //   50                   | push                eax

        $sequence_22 = { 6a6d 56 ff15???????? be???????? 8bf8 e8???????? }
            // n = 6, score = 200
            //   6a6d                 | push                0x6d
            //   56                   | push                esi
            //   ff15????????         |                     
            //   be????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     

        $sequence_23 = { c744241430124000 c744241800000000 c744241c00000000 89442420 ffd6 68007f0000 6a00 }
            // n = 7, score = 200
            //   c744241430124000     | mov                 dword ptr [esp + 0x14], 0x401230
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0
            //   c744241c00000000     | mov                 dword ptr [esp + 0x1c], 0
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   ffd6                 | call                esi
            //   68007f0000           | push                0x7f00
            //   6a00                 | push                0

        $sequence_24 = { 8b2d???????? 8b442410 8d542410 52 57 50 ffd3 }
            // n = 7, score = 200
            //   8b2d????????         |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   52                   | push                edx
            //   57                   | push                edi
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_25 = { 8b542428 50 68???????? 6a01 }
            // n = 4, score = 200
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   50                   | push                eax
            //   68????????           |                     
            //   6a01                 | push                1

    condition:
        7 of them and filesize < 811008
}