rule win_ascentloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ascentloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ascentloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b8???????? eb0a b900240000 b8???????? }
            // n = 4, score = 100
            //   b8????????           |                     
            //   eb0a                 | jmp                 0xc
            //   b900240000           | mov                 ecx, 0x2400
            //   b8????????           |                     

        $sequence_1 = { 8b4df4 e8???????? 57 ff15???????? ff15???????? }
            // n = 5, score = 100
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_2 = { 8bf8 897dd8 85ff 7516 83c8ff e9???????? c745e440ac4100 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi
            //   85ff                 | test                edi, edi
            //   7516                 | jne                 0x18
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   c745e440ac4100       | mov                 dword ptr [ebp - 0x1c], 0x41ac40

        $sequence_3 = { 740b 8b55e8 8b4dfc e8???????? 8b4dfc }
            // n = 5, score = 100
            //   740b                 | je                  0xd
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_4 = { 8955fc 83b88400000000 0f86ea000000 56 8bb080000000 }
            // n = 5, score = 100
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   83b88400000000       | cmp                 dword ptr [eax + 0x84], 0
            //   0f86ea000000         | jbe                 0xf0
            //   56                   | push                esi
            //   8bb080000000         | mov                 esi, dword ptr [eax + 0x80]

        $sequence_5 = { c744243a62756700 ff15???????? 8b35???????? ffd6 }
            // n = 4, score = 100
            //   c744243a62756700     | mov                 dword ptr [esp + 0x3a], 0x677562
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   ffd6                 | call                esi

        $sequence_6 = { 57 68000000f0 6a01 33db 894de8 53 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000
            //   6a01                 | push                1
            //   33db                 | xor                 ebx, ebx
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   53                   | push                ebx

        $sequence_7 = { 3b4814 7604 33c0 eb14 8b45fc 8b4df8 03481c }
            // n = 7, score = 100
            //   3b4814               | cmp                 ecx, dword ptr [eax + 0x14]
            //   7604                 | jbe                 6
            //   33c0                 | xor                 eax, eax
            //   eb14                 | jmp                 0x16
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   03481c               | add                 ecx, dword ptr [eax + 0x1c]

        $sequence_8 = { e8???????? 8b4d10 8bd0 8b4514 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8bd0                 | mov                 edx, eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_9 = { 005caa40 0023 d18a0688078a 46 }
            // n = 4, score = 100
            //   005caa40             | add                 byte ptr [edx + ebp*4 + 0x40], bl
            //   0023                 | add                 byte ptr [ebx], ah
            //   d18a0688078a         | ror                 dword ptr [edx - 0x75f877fa], 1
            //   46                   | inc                 esi

    condition:
        7 of them and filesize < 253952
}